<div class="page-title">
  <div>
    <h1><i class="icon-cogs"></i> Raport operacyjny dla zespołu "<?= $team->getName(); ?>"</h1>
  </div>
</div>

<div class="row raport raport-operacyjny">
  <div class="col-md-12">
    <div class="box box-gray">

      <div class="box-title">
        <h3><i class="icon-cogs"></i> Raport operacyjny</h3>
        <div class="box-tool">
          <a data-action="collapse" href="#"><i class="icon-chevron-up"></i></a>
        </div>
      </div>
      <div class="box-content">
        <a class="btn btn-primary btn-sm mb10" href="<?= url_for('@teamArchive?game_id='.$team->getGameId()); ?>"><i class="icon-mail-reply"></i> Wróć do zespołów</a>
        
        <table class="table table-striped table-hover fill-head">
          <tbody>
            <?php
            $roundCategoryData = $raportData['operacyjny']['runda_16'];
            ?>
            <?php foreach ($roundCategoryData as $category => $categoryData): ?>
              <tr level="0"  row="<?= $category; ?>">
                <td colspan="2" class="td-title">
                  <?= __t($category, array(), 'raport_operacyjny') ?>
                </td>
              </tr>

              <?php foreach ($categoryData as $key => $value): ?>
                <tr level="1" record="<?= Slug::slugify($category) ?>" row="<?= $key; ?>">
                  <td>
                    <?= __t($key, array(), 'raport_operacyjny') ?>
                  </td>
                  <?php if ($category == 'firma' || $category === 'marza') : ?>
                    <td>
                      <span>
                        <?php if ($value === 'brak_pokoi_standard'): ?>
                          <?= __t('Brak pokoi Standard', array(), 'raport_operacyjny'); ?>
                        <?php elseif ($value === 'brak_pokoi_lux'): ?>
                          <?= __t('Brak pokoi Delux', array(), 'raport_operacyjny'); ?>
                        <?php elseif ($value === 'brak_pracownikow'): ?>
                          <?= __t('Brak pracowników', array(), 'raport_operacyjny'); ?>
                        <?php else: ?>
                          <?= HotelGameFunctions::format_money_value($value); ?>
                        <?php endif; ?>
                      </span>
                    </td>
                  <?php elseif ($category == 'konkurencja'): ?>
                    <td>
                      <span>
                        <?php if ($value === 'brak_konkurencji'): ?>
                            <?= __t('Za wcześnie, aby dokładnie oszacować konkurencję', array(), 'raport_operacyjny'); ?>
                        <?php else: ?>
                          <?php $sum = $value['p1'] + $value['p2'] + $value['p3']; ?>
                          <?= round($value['p1'] * 100 / $sum) .' % / ' ?>
                          <?= round($value['p2'] * 100 / $sum) .' % / ' ?>
                          <?= round($value['p3'] * 100 / $sum) .' %' ?>
                        <?php endif; ?>
                      </span>
                    </td>
                  <?php else: ?>
                    <td>
                      <span>
                        <?php if ($value === 'brak_pokoi_standard'): ?>
                          <?= __t('Brak pokoi Standard', array(), 'raport_operacyjny'); ?>
                        <?php elseif ($value === 'brak_pokoi_lux'): ?>
                          <?= __t('Brak pokoi Delux', array(), 'raport_operacyjny'); ?>
                        <?php elseif ($value === 'brak_pracownikow'): ?>
                          <?= __t('Brak pracowników', array(), 'raport_operacyjny'); ?>
                        <?php elseif ($value === 'brak_efektywnosci_marketingu_standard'): ?>
                          <?= __t('Za wcześnie, aby dokładnie oszacować efektywność', array(), 'raport_operacyjny'); ?>
                        <?php elseif ($value === 'brak_efektywnosci_marketingu_lux'): ?>
                          <?= __t('Za wcześnie, aby dokładnie oszacować efektywność', array(), 'raport_operacyjny'); ?>
                        <?php elseif ($value === 'brak_jakosci_pokoju_standard'): ?>
                          <?= __t('Za wcześnie, aby dokładnie oszacować jakość', array(), 'raport_operacyjny'); ?>
                        <?php elseif ($value === 'brak_jakosci_pokoju_lux'): ?>
                          <?= __t('Za wcześnie, aby dokładnie oszacować jakość', array(), 'raport_operacyjny'); ?>
                        <?php elseif ($value === 'brak_satysfakcji_klienta_standard'): ?>
                          <?= __t('Za wcześnie, aby dokładnie oszacować satysfakcję', array(), 'raport_operacyjny'); ?>
                        <?php elseif ($value === 'brak_satysfakcji_klienta_lux'): ?>
                          <?= __t('Za wcześnie, aby dokładnie oszacować satysfakcję', array(), 'raport_operacyjny'); ?>
                        <?php else: ?>
                          <?= round($value, 0) ?><?= ($category === 'oblozenie') ? ' %' : ''; ?>
                        <?php endif; ?>
                      </span>
                    </td>
                  <?php endif; ?>
                <?php endforeach; ?>
              <?php endforeach; ?>
          </tbody>
        </table>
        
        <a class="btn btn-primary btn-sm mt10" href="<?= url_for('@teamArchive?game_id='.$team->getGameId()); ?>"><i class="icon-mail-reply"></i> Wróć do zespołów</a>
      </div>
    </div>
  </div>
</div>