<?php

require_once dirname(__FILE__) . '/../lib/usersGeneratorConfiguration.class.php';
require_once dirname(__FILE__) . '/../lib/usersGeneratorHelper.class.php';

/**
 * users actions.
 *
 * @package    hotel
 * @subpackage users
 * @author     Your name here
 * @version    SVN: $Id: actions.class.php 23810 2009-11-12 11:07:44Z Kris.Wallsmith $
 */
class usersActions extends autoUsersActions {

    public function executeMojeKonto(sfWebRequest $request) {
        
    }

    public function executeChangeSfGuardUserPassword(sfWebRequest $request) {
        $sfGuardUser = Doctrine::getTable('sfGuardUser')->findOneById($request->getParameter('id'));

        if ($sfGuardUser && $sfGuardUser->getUserDetails()->getFirst()) {
            if ($sfGuardUser->getUserDetails()->getFirst()->getGame()->getTeacherId() == $this->getUser()->getId()) {
                $this->form = new FlatyChangeUserPasswordForm($sfGuardUser);

                if ($request->hasParameter($this->form->getName()) && $request->isMethod('POST')) {
                    $this->form->bind($request->getParameter($this->form->getName()), $request->getFiles($this->form->getName()));
                    if ($this->form->isValid()) {
                        $this->form->save();
                        $this->getUser()->setNotice('Hasło użytkownika "' . $sfGuardUser->getEmailAddress() . '" zostało pomyślnie zmienione');
                        $this->redirect('@users');
                    }
                }
            } else {
                $this->getUser()->setError('Brak uprawnien do zmiany hasla tego uzytkownika.');
                $this->redirect('@users');
            }
        } else {
            $this->getUser()->setError('Brak uprawnien do zmiany hasla tego uzytkownika.');
            $this->redirect('@users');
        }
    }

    public function executeResetPassword(sfWebRequest $request) {
        $user = $this->getRoute()->getObject();
        $password = substr(md5($user->getUpdatedAt() . 'hs' . $user->getName()), 0, 8);
        $user->setPassword($password);
        $user->save();

        $emailKontaktowy = ArtConfiguration::getConfig('contact_email', 'hotelstars@arteneo.pl');
        $vars = array(
            'password' => $password,
        );
        $sender = new MessageSender();
        $sender->send($emailKontaktowy, $user->getEmailAddress(), $sender->getComponentBody('messages', 'resetPassword', $vars, 'panel'), 'HotelStars - Restart hasła');


        $this->getUser()->setNotice('Nowe hasło zostało zostało wysłane na e-mail "' . $user->getEmailAddress() . '"');
        $this->redirect('@users');
    }

    public function executeActivate(sfWebRequest $request) {
        $user = $this->getRoute()->getObject();
        $user->setIsActive(1);
        $user->save();

        $this->getUser()->setNotice('Użytkownik "' . $user->getEmailAddress() . '" został aktywowany');
        $this->redirect('@users');
    }

}
