<?php

require_once(dirname(__FILE__).'/../lib/BaseGameGeneratorConfiguration.class.php');
require_once(dirname(__FILE__).'/../lib/BaseGameGeneratorHelper.class.php');

/**
 * game actions.
 *
 * @package    ##PROJECT_NAME##
 * @subpackage game
 * @author     ##AUTHOR_NAME##
 * @version    SVN: $Id: actions.class.php 31002 2010-09-27 12:04:07Z Kris.Wallsmith $
 */
abstract class autoGameActions extends artActions
{
  public function preExecute()
  {
    $this->configuration = new gameGeneratorConfiguration();

    if (!$this->getUser()->hasCredential($this->configuration->getCredentials($this->getActionName())))
    {
      $this->forward(sfConfig::get('sf_secure_module'), sfConfig::get('sf_secure_action'));
    }

    $this->dispatcher->notify(new sfEvent($this, 'admin.pre_execute', array('configuration' => $this->configuration)));

    $this->helper = new gameGeneratorHelper();
    $this->helper->setConfigurationObject($this->configuration);

    if (!$this->hasFilterParam())
      $this->setFilterParam(' ');
    
    parent::preExecute();
  }

  public function executeIndex(sfWebRequest $request)
  {
    $this->request = $request;
    if ($request->hasParameter('max_per_page'))
    {
      $this->configuration->setPagerMaxPerPage($request->getParameter('max_per_page'));
      $this->setPage(1);
      $this->redirect('@game' . $this->configuration->getFollowParametersStringWithQuestionMark($request));
    }
  
  
    $filterDefaults = $this->configuration->getFilterDefaults();
    
    artDebug::logWarning("arteneotheme: executeIndex: hasFilters(): ".$this->hasFilters());
    
    if (!$this->hasFilters() && !empty($filterDefaults))
    {
      $this->executeFilter($request);
      
      artDebug::logWarning("arteneotheme: executeIndex: if not hasFilters()");
    }
    else if ($this->filtersForceUpdate)
    {
      artDebug::logWarning("arteneotheme: executeIndex: if hasFilters()");
      
      $this->executeFilter($request);
    }
      
    artDebug::logWarning("arteneotheme: executeIndex: filtersForceUpdate=".$this->filtersForceUpdate." hasFilters=".$this->hasFilters());
    // sorting
    if ($request->getParameter('sort') && $this->isValidSortColumn($request->getParameter('sort')))
    {
      $this->setSort(array($request->getParameter('sort'), $request->getParameter('sort_type')));
      //$this->redirect('@game' . $this->configuration->getFollowParametersStringWithQuestionMark($request));
    }

    // pager
    if ($request->getParameter('page'))
      $this->setPage($request->getParameter('page'));

    $this->pager = $this->getPager();
    $this->sort = $this->getSort();
    
  }
  public function executeFilter(sfWebRequest $request)
  {
    $this->setPage(1);
    $this->request = $request;
    
    if ($request->hasParameter('_reset'))
    {
      $this->setFilters(array());

      if ($request->isXmlHttpRequest())
        $this->forward('game', 'index');
      //else
        //$this->redirect('@game');
    }

    $this->filters = $this->configuration->getFilterForm($this->getFilters());

    if ($request->hasParameter($this->filters->getName()))
      $filterValues = $request->getParameter($this->filters->getName());
    else
    {
      unset($this->filters['_csrf_token']);
      $filterValues = $this->configuration->getFilterDefaults();
    }
   
    $filterValues = array_merge($this->getFilterArrayForParam($this->getFilterParam()), $filterValues);
    $this->filters->bind($filterValues);
    
    if ($this->filters->isValid())
    {
      $this->setFilters($this->filters->getValues());
      
      
      if ($this->getFilterParam() != ' ' && !$request->hasParameter('_reset'))
      {
        $this->setFilterParam(' ');
        $this->setFilters($this->filters->getValues());
      }
      
      if ($request->isXmlHttpRequest())
        $this->forward('game', 'index');
      else
        $this->redirect('@game');
    }

    $this->pager = $this->getPager();
    $this->sort = $this->getSort();

    $this->setTemplate('index');
  }

  public function executeLinkFilter(sfWebRequest $request)
  {
    $this->request = $request;
    $param = $request->getParameter('param', false);
    if ($param)
    {
      if ($param == '_reset')
      {
        $this->setFilterParam(' ');
        $this->setFilters(array());
      }
      // parametry filtru będą zawsze zmieniane w sesji
      //else if ($this->hasFiltersFromLink($param))
      //  $this->setFilterParam($param);
      else
      {
        $filters = $this->getFilterArrayForParam($param);
        
        $filterForm = $this->configuration->getFilterFormWithoutCSRF($filters);
        $filterForm->bind($filters);
        
        
        if ($filterForm->isValid())
        {
          artDebug::logWarning("arteneotheme: filterAction: executeLinkFilter(): formValid");
          
          $this->setFiltersFromLink($filterForm->getValues(), $param);
        }else
        {
          artDebug::logWarning("arteneotheme: filterAction: executeLinkFilter(): form is not valid: ");
        }
    
      }
    }
    
    $paramsList = $this->getParamsList();
    
    if ($request->isXmlHttpRequest())
      $this->forward('game', 'index'.$paramsList);
    else
      $this->redirect('@game'.$paramsList);
  }
  
  public function getLinkFilterArray($paramArray = null)
  {
    return array();
  }
  
  protected function getParamsList()
  {
    if (!isset ($this->request))
      return '';
      
    $paramArray = $this->request->getParameterHolder()->getAll();  
    
    unset($paramArray['module']);
    unset($paramArray['action']);
    unset($paramArray['sf_format']);
    
    $paramsList = '';
    
    if (!empty($paramArray))
    {
      $paramsList = '?';
    
      foreach ($paramArray as $key => $value)
      {
        if ($paramsList != '?') 
          $paramsList .= '&';
          
        $paramsList .= urlencode($key).'='.urlencode($value);
      }
      
    }
    
    return $paramsList;
  }
  public function executeNew(sfWebRequest $request)
  {
    $this->form = $this->configuration->getForm();
    $this->game = $this->form->getObject();
  }

  public function executeCreate(sfWebRequest $request)
  {
    $this->form = $this->configuration->getForm();
    $this->game = $this->form->getObject();

    $this->processForm($request, $this->form);

    $this->setTemplate('new');
  }

  public function executeEdit(sfWebRequest $request)
  {
    $this->game = $this->getRoute()->getObject();
    $this->form = $this->configuration->getForm($this->game);
  }

  public function executeUpdate(sfWebRequest $request)
  {
    $this->game = $this->getRoute()->getObject();
    $this->form = $this->configuration->getForm($this->game);

    $this->processForm($request, $this->form);

    $this->setTemplate('edit');
  }
  
  protected function processForm(sfWebRequest $request, sfForm $form)
  {
    $followParameters = $request->getParameter('follow_parameters');

    $redirectString = $this->configuration->getFollowParametersString($followParameters);
    $redirectStringWithQuestionMark = $this->configuration->getFollowParametersStringWithQuestionMark($followParameters);
    
    $form->bind($request->getParameter($form->getName()), $request->getFiles($form->getName()));
    
    if ($form->isValid())
    {
      $notice = $form->getObject()->isNew() ? 'Obiekt został utworzony pomyślnie.' : 'Element został zaktualizowany.';

      try {
        $game = $form->save();
      } 
      catch (Doctrine_Validator_Exception $e) 
      {
        $errorStack = $form->getObject()->getErrorStack();
        $message = get_class($form->getObject()) . ' has ' . count($errorStack) . " field" . (count($errorStack) > 1 ?  's' : null) . " with validation errors: ";
        
        foreach ($errorStack as $field => $errors)
            $message .= "$field (" . implode(", ", $errors) . "), ";

        $message = trim($message, ', ');

        $this->getUser()->setFlash('error', $message);
        return sfView::SUCCESS;
      }
    
      if ($this->configuration->getFormDebug())
        return sfView::NONE;

      $this->dispatcher->notify(new sfEvent($this, 'admin.save_object', array('object' => $game)));

      if ($request->hasParameter('_save_and_add'))
      {
        $this->getUser()->setFlash('notice', $notice.' Możesz teraz dodać kolejny.');

        $this->redirect('@' . $this->configuration->getRoutePrefix() . '_new' . $redirectStringWithQuestionMark);
      }
      else
      {
        $this->getUser()->setFlash('notice', $notice);

        $this->redirect('@' . $this->configuration->getRoutePrefix() . '_edit?id=' . $game->getId() . $redirectString);
      }
    }
    else
      $this->getUser()->setFlash('error', 'Obiekt nie został utworzony, wystąpiły błędy.', false);
  }
  
  public function executeChangePage(sfWebRequest $request)
  {
    $this->setPage($request->getParameter('page'));
    $this->executeIndex($request);
    $this->setTemplate('list');
  }
  
  public function executeAjaxSorting(sfWebRequest $request)
  {
    $this->executeIndex($request);
    $this->setTemplate('list');
  }
  
  public function executeDelete(sfWebRequest $request)
  {
    $request->checkCSRFProtection();

    $this->dispatcher->notify(new sfEvent($this, 'admin.delete_object', array('object' => $this->getRoute()->getObject())));

    if ($this->getRoute()->getObject()->delete())
    {
      $this->getUser()->setFlash('notice', 'Element został usunięty pomyślnie.');
    }

    $this->redirect('@game' . $this->configuration->getFollowParametersStringWithQuestionMark($request));
  }


  protected function getFilters()
  {
    $filters = $this->getFilterArrayForParam($this->getFilterParam());
    
    artDebug::logWarning("arteneotheme: filtersAction: getFilters(): filters=".print_r($filters,true));
    artDebug::logWarning("arteneotheme: filtersAction: getFilters(): filtersForceUpdate=".$this->filtersForceUpdate." param=".$this->getFilterParam());
    
    if ($this->filtersForceUpdate)
      return $filters;
        
    return $this->getUser()->getAttribute('filters', $filters, 'game.filters[' . $this->getFilterParam() . ']');
  }

  protected function setFilters(array $filters)
  {
    if (empty($filters) && !isset($this->filtersForceUpdate))
      $filters = $this->getFilterArrayForParam($this->getFilterParam());
    
    artDebug::logWarning("arteneotheme: filtersAction: setFilters(): filters=".print_r($filters,true));
      
    $this->getUser()->setAttribute('filters', $filters, 'game.filters[' . $this->getFilterParam() . ']');
  }

  protected function hasFilters()
  {
    artDebug::logWarning("arteneotheme: filtersAction: hasFilters(): filtersForceUpdate=".$this->filtersForceUpdate);
    if ($this->filtersForceUpdate) 
      return false;
        
    return $this->getUser()->hasAttribute('filters', 'game.filters[' . $this->getFilterParam() . ']') ;
  }

  protected function hasFilterParam()
  {
    return $this->getUser()->hasAttribute('filterParam', 'game') ;
  }
  
  protected function setFilterParam($param)
  {
    $this->getUser()->setAttribute('filterParam', $param, 'game');
  }
  
  protected function getFilterParam()
  {
    return $this->getUser()->getAttribute('filterParam', ' ', 'game');
  }
  
  protected function setFiltersFromLink(array $filters, $param)
  {
    $this->setFilterParam($param);
  
    $this->setFilters($filters);
  }

  protected function hasFiltersFromLink($param)
  {
    return $this->getUser()->hasAttribute('filters', 'game.filters[' . $param . ']') ;
  }
  
  protected function getFilterArrayForParam($param, $defaults = false)
  {
    if (isset ($this->request))
      $paramArray = $this->request->getParameterHolder()->getAll();
    else 
      $paramArray = array();
   
    $linkFilterArray = $this->getLinkFilterArray($paramArray);
    
    if ($defaults === false)
      $defaults = $this->configuration->getFilterDefaults();
      
    $linkArray = artArray::getFromArray($linkFilterArray, $param, $defaults);
    
    artDebug::logWarning("arteneotheme: filtersAction: linkArray=".print_r($linkArray, true));
    
    if (isset ($linkArray['filters-force-update']) && $linkArray['filters-force-update'])
    {
      $this->filtersForceUpdate = true;
      unset($linkArray['filters-force-update']);
    }
      
      
    artDebug::logWarning("arteneotheme: filtersAction: getFilterArrayForParam(): filtersForceUpdate=".$this->filtersForceUpdate);
       
    return $linkArray;
  }

  protected function getPager()
  {
    $pager = $this->configuration->getPager('Game');
    $pager->setQuery($this->buildQuery());
    $pager->setPage($this->getPage());
    $pager->init();

    return $pager;
  }

  protected function setPage($page)
  {
    $this->getUser()->setAttribute('page[' . $this->getFilterParam() . ']', $page, 'game');
  }

  protected function getPage()
  {
    return $this->getUser()->getAttribute('page[' . $this->getFilterParam() . ']', 1, 'game');
  }

  protected function buildQuery()
  {
    $tableMethod = $this->configuration->getTableMethod();
    $query = Doctrine_Core::getTable('Game')
      ->createQuery('a');

    if ($tableMethod)
    {
      $query = Doctrine_Core::getTable('Game')->$tableMethod($query);
    }

    $this->addSortQuery($query);

    $event = $this->dispatcher->filter(new sfEvent($this, 'admin.build_query'), $query);
    $query = $event->getReturnValue();

    return $query;
  }

  protected function addSortQuery($query)
  {
    if (array(null, null) == ($sort = $this->getSort()))
      return;

    if (!in_array(strtolower($sort[1]), array('asc', 'desc')))
      $sort[1] = 'asc';

    $fields = $this->configuration->getFieldsDefault();
    $sortType = $sort[1];

    if (!isset($fields[$sort[0]]['sort']))
      $query->addOrderBy($sort[0] . ' ' . $sortType);
    else
    {
      $this->sortOptions = $fields[$sort[0]]['sort'];

      if (!isset($this->sortOptions['custom_function']))
        $this->extendAddSortQuery($query, $sortType);
      else
      {
        $function = 'addOrderBy' . sfInflector::camelize($sort[0]);
        $this->$function($query, $sortType);
      }
    }
  }

  protected function extendAddSortQuery($query, $sortType)
  {
    $dqlPartFrom = $query->getDqlPart('from');
    $sortModel = $this->sortOptions['model'];

    if (isset($this->sortOptions['model_translation_prefix']))
      $sortModel = $this->sortOptions['model_translation_prefix'];
    else if ('Game' == $sortModel)
      $sortModel = $query->getRootAlias();
    else
      foreach ($dqlPartFrom as $from)
      {
        $fromPosition = strpos($from, '.' . $sortModel . ' ');

        if ($fromPosition !== false)
        {
          $tab = explode(' ', substr($from, $fromPosition));
          $sortModel = $tab[1];
          break;
        }
      }

    if (isset($this->sortOptions['column']))
    {
      $sortColumn = $this->sortOptions['column'];
      $query->addOrderBy($sortModel . '.' . $sortColumn . ' ' . $sortType);
    }
    else if (isset($this->sortOptions['columns']))
    {
      $sortColumns = $this->sortOptions['columns'];
      $orderBy = '';

      foreach ($sortColumns as $sortColumn)
        $orderBy .= $sortModel . '.' . $sortColumn . ' ' . $sortType . ',';

      $orderBy = substr($orderBy, 0, -1);

      $query->addOrderBy($orderBy);
    }
  }

  protected function getSort()
  {
    if (null !== $sort = $this->getUser()->getAttribute('sort', null, 'game'))
    {
      return $sort;
    }

    $this->setSort($this->configuration->getDefaultSort());

    return $this->getUser()->getAttribute('sort', null, 'game');
  }

  protected function setSort(array $sort)
  {
    if (null !== $sort[0] && null === $sort[1])
    {
      $sort[1] = 'asc';
    }

    $this->getUser()->setAttribute('sort', $sort, 'game');
  }

  protected function isValidSortColumn($column)
  {
    return $this->configuration->isValidSortColumn($column);
  }
}
