<?php

/**
 * game module configuration.
 *
 * @package    ##PROJECT_NAME##
 * @subpackage game
 * @author     ##AUTHOR_NAME##
 * @version    SVN: $Id: configuration.php 24171 2009-11-19 16:37:50Z Kris.Wallsmith $
 */
abstract class BaseGameGeneratorConfiguration extends sfModelGeneratorConfiguration
{

  public $followParametersString = null;
  public $followParametersStringWithQuestionMark = null;
  
  public function getActionsDefault()
  {
    return array();
  }

  public function getFormActions()
  {
    return array(  '_delete' => NULL,  '_list' => NULL,  '_save' => NULL,  '_save_and_add' => NULL,);
  }

  public function getNewActions()
  {
    return array();
  }

  public function getEditActions()
  {
    return array(  '_save' => NULL,  '_delete' => NULL,  '_list' => NULL,);
  }

  public function getListObjectActions()
  {
    return array(  'activate' =>   array(    'label' => 'Aktywuj',    'action' => 'activate',    'object_condition' => 'canBeActivated',    'params' =>     array(      'class' => 'btn btn-success btn-sm',      'icon-class' => 'icon-bullhorn',    ),  ),  'next_round' =>   array(    'label' => 'Następna runda',    'action' => 'nextRound',    'object_condition' => 'hasNextRound',    'params' =>     array(      'class' => 'btn btn-primary btn-sm',      'icon-class' => 'icon-repeat',    ),  ),  'archive' =>   array(    'label' => 'Archiwizuj',    'action' => 'archive',    'object_condition' => 'canBeArchived',    'params' =>     array(      'class' => 'btn btn-warning btn-sm',      'icon-class' => 'icon-folder-open',    ),  ),);
  }

  public function getListActions()
  {
    return array();
  }

  public function getListBatchActions()
  {
    return array();
  }

  public function getFormDebug()
  {
    return false;
  }
  

  public function getListParams()
  {
    return '%%name%% - %%teams_count%% - %%round_num%% - %%created_at%%';
  }

  public function getListLayout()
  {
    return 'tabular';
  }

  public function getListTitle()
  {
    return 'Lista gier';
  }
  
  public function getListIcon()
  {
    return 'icon-puzzle-piece';
  }

  public function getEditTitle()
  {
    return 'Edycja Game';
  }

  public function getNewTitle()
  {
    return 'Nowy Game';
  }
  
  public function getNewDescription()
  {
    return '';
  }
  
  public function getNewIcon()
  {
    return '';
  }

  public function getFilterDisplay()
  {
    return array();
  }

  public function getFormDisplay()
  {
    return array();
  }

  public function getEditDisplay()
  {
    return array();
  }
  
  public function getEditDescription()
  {
    return '';
  }
  
  public function getEditIcon()
  {
    return '';
  }

  public function getNewDisplay()
  {
    return array();
  }

  public function getListDisplay()
  {
    return array(  0 => 'name',  1 => 'teams_count',  2 => 'round_num',  3 => 'created_at',);
  }

  public function getFieldsDefault()
  {
    return array(
      'id' => array(  'is_link' => true,  'is_real' => true,  'is_partial' => false,  'is_component' => false,  'type' => 'Text',),
      'teacher_id' => array(  'is_link' => false,  'is_real' => true,  'is_partial' => false,  'is_component' => false,  'type' => 'ForeignKey',),
      'name' => array(  'is_link' => false,  'is_real' => true,  'is_partial' => false,  'is_component' => false,  'type' => 'Text',  'label' => 'Nazwa gry',),
      'status' => array(  'is_link' => false,  'is_real' => true,  'is_partial' => false,  'is_component' => false,  'type' => 'Text',),
      'game_data_json' => array(  'is_link' => false,  'is_real' => true,  'is_partial' => false,  'is_component' => false,  'type' => 'Text',),
      'game_controller_class' => array(  'is_link' => false,  'is_real' => true,  'is_partial' => false,  'is_component' => false,  'type' => 'Text',),
      'created_at' => array(  'is_link' => false,  'is_real' => true,  'is_partial' => false,  'is_component' => false,  'type' => 'Date',  'label' => 'Data stworzenia',),
      'updated_at' => array(  'is_link' => false,  'is_real' => true,  'is_partial' => false,  'is_component' => false,  'type' => 'Date',),
      'teams_count' => array(  'is_link' => false,  'is_real' => false,  'is_partial' => false,  'is_component' => false,  'type' => 'Text',  'label' => 'Liczba zespołów',),
      'round_num' => array(  'is_link' => false,  'is_real' => false,  'is_partial' => false,  'is_component' => false,  'type' => 'Text',  'label' => 'Runda',),
    );
  }

  public function getFieldsList()
  {
    return array(
      'id' => array(),
      'teacher_id' => array(),
      'name' => array(),
      'status' => array(),
      'game_data_json' => array(),
      'game_controller_class' => array(),
      'created_at' => array(),
      'updated_at' => array(),
    );
  }

  public function getFieldsFilter()
  {
    return array(
      'id' => array(),
      'teacher_id' => array(),
      'name' => array(),
      'status' => array(),
      'game_data_json' => array(),
      'game_controller_class' => array(),
      'created_at' => array(),
      'updated_at' => array(),
    );
  }

  public function getFieldsForm()
  {
    return array(
      'id' => array(),
      'teacher_id' => array(),
      'name' => array(),
      'status' => array(),
      'game_data_json' => array(),
      'game_controller_class' => array(),
      'created_at' => array(),
      'updated_at' => array(),
    );
  }

  public function getFieldsEdit()
  {
    return array(
      'id' => array(),
      'teacher_id' => array(),
      'name' => array(),
      'status' => array(),
      'game_data_json' => array(),
      'game_controller_class' => array(),
      'created_at' => array(),
      'updated_at' => array(),
    );
  }

  public function getFieldsNew()
  {
    return array(
      'id' => array(),
      'teacher_id' => array(),
      'name' => array(),
      'status' => array(),
      'game_data_json' => array(),
      'game_controller_class' => array(),
      'created_at' => array(),
      'updated_at' => array(),
    );
  }


  public function getFormLevels()
  {
      return false;
  }
  
  public function forceRenderLevels()
  {
    return false;
  }
  
  public function getPassParameters()
  {
      return array();
  }
  
  public function getRoutePrefix()
  {
      return 'game';
  }

  public function getFilterDefaults()
  {
    return array(
    );
  }
  
  public function getFilterFormLevels(sfForm $form)
  {
    $fields = $this->getFormFilterFields($form);
    $fields = array_keys($fields);
    $fields = array_diff($fields, $form->getHiddenFields());
    
    return array_chunk($fields, $this->getFilterMaxPerLevel());
  }
  
  public function getFilterMaxPerLevel()
  {
    return 2;
  }
  
   public function getFilterFormWithoutCSRF($filters)
  {
    $class = $this->getFilterFormClass();

    return new $class($filters, $this->getFilterFormOptions(), false);
  }
  public function getFormClass()
  {
    return 'GameForm';
  }

  public function hasFilterForm()
  {
    return false;
  }

  /**
   * Gets the filter form class name
   *
   * @return string The filter form class name associated with this generator
   */
  public function getFilterFormClass()
  {
    return 'GameFormFilter';
  }

  public function getPagerClass()
  {
    return 'artDoctrinePager';
  }

  public function getPagerMaxPerPage()
  {
    if (isset($_COOKIE[sfConfig::get('sf_app') . '_game_max_per_page']))
      return $_COOKIE[sfConfig::get('sf_app') . '_game_max_per_page'];
  
    return sfContext::getInstance()->getUser()->getAttribute(sfConfig::get('sf_app') . '_max_per_page', 20, 'game');
  }
  
  public function setPagerMaxPerPage($value)
  {
    if (is_int(intval($value)) && in_array($value, $this->getMaxPerPageList()))
    {
      sfContext::getInstance()->setAttribute(sfConfig::get('sf_app') . '_max_per_page', $value, 'game');
      setcookie(sfConfig::get('sf_app') . '_game_max_per_page', $value);
    }
  }
  
  public function getMaxPerPageList()
  {
    return array(  0 => 10,  1 => 20,  2 => 50,);
  }
  
  public function getMaxPerPageStyle()
  {
    return false; //select or list
  }
  
  public function isAjaxPaginator()
  {
    return false;
  }
  
  public function isAppendPagination()
  {
    return false;
  }
  
  public function getAjaxPaginationStyle()
  {
    return 'left-right';
  }

  public function getDefaultSort()
  {
    return array(null, null);
  }

  public function isValidSortColumn($column)
  {
    $fields = $this->getFieldsDefault();

    if (isset($fields[$column]['sort']))
    {
      $sortOptions = $fields[$column]['sort'];
      
      if (isset($sortOptions['custom_function']))
        return true;
        
      $model = $sortOptions['model'];
      $column = isset($sortOptions['columns']) ?$sortOptions['columns'][0] : $sortOptions['column'];
      
      if (isset($sortOptions['model_translation_prefix']))
        return Doctrine_Core::getTable($model)->hasI18nColumn($column);
    }
    else
      $model = 'Game';
      
    return Doctrine_Core::getTable($model)->hasColumn($column);
  }
  
  public function isAjaxSorting()
  {
    return false;
  }

  public function getAjaxSortingStyle()
  {
    return 'top-bottom';
  }
  
  public function getTableMethod()
  {
    return 'getPanelGames';
  }

  public function getTableCountMethod()
  {
    return '';
  }
  
  public function getFollowParametersString($source)
  {
    if (is_null($this->followParametersString))
      $this->setFollowParametersStrings($source);
      
    return $this->followParametersString;
  }
  
  public function getFollowParametersStringWithQuestionMark($source)
  {
    if (is_null($this->followParametersStringWithQuestionMark))
      $this->setFollowParametersStrings($source);
      
    return $this->followParametersStringWithQuestionMark;
  }
  
  protected function setFollowParametersStrings($source)
  {
    if ($source instanceof sfOutputEscaperObjectDecorator)
      $source = $source->getRawValue();
      
    foreach ($this->getPassParameters() as $i => $param)
    {
      $value = '';
      
      if (is_array($source))
        $value = isset($source[$param]) ? $source[$param] : '';
      else if ($source instanceof sfWebRequest)
        $value = $source->getParameter($param, '');

      if ($value != '')
        $this->followParametersString .= '&' . $param . '=' . $value;
    }

    if (!is_null($this->followParametersString))
      $this->followParametersStringWithQuestionMark = '?' . substr($this->followParametersString, 1);
    else
      $this->followParametersStringWithQuestionMark = '';
  }
  
  public function getActionsPositions()
  {
        return array(  0 => 'bottom',);
  }
  
    public function getBottomFormActionsPosition()
  {
    return '~';
  }
    public function getTopFormActionsPosition()
  {
    return array();
  }
}
