<?php

/**
 * users module configuration.
 *
 * @package    ##PROJECT_NAME##
 * @subpackage users
 * @author     ##AUTHOR_NAME##
 * @version    SVN: $Id: configuration.php 24171 2009-11-19 16:37:50Z Kris.Wallsmith $
 */
abstract class BaseUsersGeneratorConfiguration extends sfModelGeneratorConfiguration
{

  public $followParametersString = null;
  public $followParametersStringWithQuestionMark = null;
  
  public function getActionsDefault()
  {
    return array();
  }

  public function getFormActions()
  {
    return array(  '_delete' => NULL,  '_list' => NULL,  '_save' => NULL,  '_save_and_add' => NULL,);
  }

  public function getNewActions()
  {
    return array();
  }

  public function getEditActions()
  {
    return array();
  }

  public function getListObjectActions()
  {
    return array(  'activate' =>   array(    'label' => 'Aktywuj',    'action' => 'activate',    'object_condition' => 'getIsNotActive',    'params' =>     array(      'class' => 'btn btn-success btn-sm',      'icon-class' => 'icon-signin',    ),  ),  'resetPassword' =>   array(    'label' => 'Resetuj hasło',    'action' => 'resetPassword',    'object_condition' => 'getIsActive',    'params' =>     array(      'class' => 'btn btn-warning btn-sm',      'icon-class' => 'icon-retweet',    ),  ),  'changeSfGuardUserPassword' =>   array(    'label' => 'Zmień hasło',    'action' => 'changeSfGuardUserPassword',    'object_condition' => 'getIsActive',    'params' =>     array(      'class' => 'btn btn-warning btn-sm',      'icon-class' => 'icon-lock',    ),  ),);
  }

  public function getListActions()
  {
    return array();
  }

  public function getListBatchActions()
  {
    return array();
  }

  public function getFormDebug()
  {
    return false;
  }
  

  public function getListParams()
  {
    return '%%name%% - %%email_address%% - %%teams_name%% - %%status%% - %%created_at%%';
  }

  public function getListLayout()
  {
    return 'tabular';
  }

  public function getListTitle()
  {
    return 'Lista Twoich graczy w systemie';
  }
  
  public function getListIcon()
  {
    return 'icon-user';
  }

  public function getEditTitle()
  {
    return 'Edycja Users';
  }

  public function getNewTitle()
  {
    return 'Nowy Users';
  }
  
  public function getNewDescription()
  {
    return '';
  }
  
  public function getNewIcon()
  {
    return '';
  }

  public function getFilterDisplay()
  {
    return array();
  }

  public function getFormDisplay()
  {
    return array();
  }

  public function getEditDisplay()
  {
    return array();
  }
  
  public function getEditDescription()
  {
    return '';
  }
  
  public function getEditIcon()
  {
    return '';
  }

  public function getNewDisplay()
  {
    return array();
  }

  public function getListDisplay()
  {
    return array(  0 => 'name',  1 => 'email_address',  2 => 'teams_name',  3 => 'status',  4 => 'created_at',);
  }

  public function getFieldsDefault()
  {
    return array(
      'id' => array(  'is_link' => true,  'is_real' => true,  'is_partial' => false,  'is_component' => false,  'type' => 'Text',),
      'first_name' => array(  'is_link' => false,  'is_real' => true,  'is_partial' => false,  'is_component' => false,  'type' => 'Text',),
      'last_name' => array(  'is_link' => false,  'is_real' => true,  'is_partial' => false,  'is_component' => false,  'type' => 'Text',),
      'email_address' => array(  'is_link' => false,  'is_real' => true,  'is_partial' => false,  'is_component' => false,  'type' => 'Text',  'label' => 'Adres e-mail',),
      'username' => array(  'is_link' => false,  'is_real' => true,  'is_partial' => false,  'is_component' => false,  'type' => 'Text',),
      'algorithm' => array(  'is_link' => false,  'is_real' => true,  'is_partial' => false,  'is_component' => false,  'type' => 'Text',),
      'salt' => array(  'is_link' => false,  'is_real' => true,  'is_partial' => false,  'is_component' => false,  'type' => 'Text',),
      'password' => array(  'is_link' => false,  'is_real' => true,  'is_partial' => false,  'is_component' => false,  'type' => 'Text',),
      'is_active' => array(  'is_link' => false,  'is_real' => true,  'is_partial' => false,  'is_component' => false,  'type' => 'Boolean',),
      'is_banned' => array(  'is_link' => false,  'is_real' => true,  'is_partial' => false,  'is_component' => false,  'type' => 'Boolean',),
      'is_super_admin' => array(  'is_link' => false,  'is_real' => true,  'is_partial' => false,  'is_component' => false,  'type' => 'Boolean',),
      'last_login' => array(  'is_link' => false,  'is_real' => true,  'is_partial' => false,  'is_component' => false,  'type' => 'Date',),
      'password_expired' => array(  'is_link' => false,  'is_real' => true,  'is_partial' => false,  'is_component' => false,  'type' => 'Date',),
      'created_at' => array(  'is_link' => false,  'is_real' => true,  'is_partial' => false,  'is_component' => false,  'type' => 'Date',  'label' => 'Data rejestracji',),
      'updated_at' => array(  'is_link' => false,  'is_real' => true,  'is_partial' => false,  'is_component' => false,  'type' => 'Date',),
      'groups_list' => array(  'is_link' => false,  'is_real' => false,  'is_partial' => false,  'is_component' => false,  'type' => 'Text',),
      'permissions_list' => array(  'is_link' => false,  'is_real' => false,  'is_partial' => false,  'is_component' => false,  'type' => 'Text',),
      'teams_list' => array(  'is_link' => false,  'is_real' => false,  'is_partial' => false,  'is_component' => false,  'type' => 'Text',),
      'message_centers_list' => array(  'is_link' => false,  'is_real' => false,  'is_partial' => false,  'is_component' => false,  'type' => 'Text',),
      'internal_messages_list' => array(  'is_link' => false,  'is_real' => false,  'is_partial' => false,  'is_component' => false,  'type' => 'Text',),
      'internal_categories_through_internal_message_category_list' => array(  'is_link' => false,  'is_real' => false,  'is_partial' => false,  'is_component' => false,  'type' => 'Text',),
      'users_list' => array(  'is_link' => false,  'is_real' => false,  'is_partial' => false,  'is_component' => false,  'type' => 'Text',),
      'name' => array(  'is_link' => false,  'is_real' => false,  'is_partial' => false,  'is_component' => false,  'type' => 'Text',  'label' => 'Imię i nazwisko',),
      'teams_name' => array(  'is_link' => false,  'is_real' => false,  'is_partial' => false,  'is_component' => false,  'type' => 'Text',  'label' => 'Nazwa zespołu',),
      'status' => array(  'is_link' => false,  'is_real' => false,  'is_partial' => false,  'is_component' => false,  'type' => 'Text',  'label' => 'Status',),
    );
  }

  public function getFieldsList()
  {
    return array(
      'id' => array(),
      'first_name' => array(),
      'last_name' => array(),
      'email_address' => array(),
      'username' => array(),
      'algorithm' => array(),
      'salt' => array(),
      'password' => array(),
      'is_active' => array(),
      'is_banned' => array(),
      'is_super_admin' => array(),
      'last_login' => array(),
      'password_expired' => array(),
      'created_at' => array(),
      'updated_at' => array(),
      'groups_list' => array(),
      'permissions_list' => array(),
      'teams_list' => array(),
      'message_centers_list' => array(),
      'internal_messages_list' => array(),
      'internal_categories_through_internal_message_category_list' => array(),
      'users_list' => array(),
    );
  }

  public function getFieldsFilter()
  {
    return array(
      'id' => array(),
      'first_name' => array(),
      'last_name' => array(),
      'email_address' => array(),
      'username' => array(),
      'algorithm' => array(),
      'salt' => array(),
      'password' => array(),
      'is_active' => array(),
      'is_banned' => array(),
      'is_super_admin' => array(),
      'last_login' => array(),
      'password_expired' => array(),
      'created_at' => array(),
      'updated_at' => array(),
      'groups_list' => array(),
      'permissions_list' => array(),
      'teams_list' => array(),
      'message_centers_list' => array(),
      'internal_messages_list' => array(),
      'internal_categories_through_internal_message_category_list' => array(),
      'users_list' => array(),
    );
  }

  public function getFieldsForm()
  {
    return array(
      'id' => array(),
      'first_name' => array(),
      'last_name' => array(),
      'email_address' => array(),
      'username' => array(),
      'algorithm' => array(),
      'salt' => array(),
      'password' => array(),
      'is_active' => array(),
      'is_banned' => array(),
      'is_super_admin' => array(),
      'last_login' => array(),
      'password_expired' => array(),
      'created_at' => array(),
      'updated_at' => array(),
      'groups_list' => array(),
      'permissions_list' => array(),
      'teams_list' => array(),
      'message_centers_list' => array(),
      'internal_messages_list' => array(),
      'internal_categories_through_internal_message_category_list' => array(),
      'users_list' => array(),
    );
  }

  public function getFieldsEdit()
  {
    return array(
      'id' => array(),
      'first_name' => array(),
      'last_name' => array(),
      'email_address' => array(),
      'username' => array(),
      'algorithm' => array(),
      'salt' => array(),
      'password' => array(),
      'is_active' => array(),
      'is_banned' => array(),
      'is_super_admin' => array(),
      'last_login' => array(),
      'password_expired' => array(),
      'created_at' => array(),
      'updated_at' => array(),
      'groups_list' => array(),
      'permissions_list' => array(),
      'teams_list' => array(),
      'message_centers_list' => array(),
      'internal_messages_list' => array(),
      'internal_categories_through_internal_message_category_list' => array(),
      'users_list' => array(),
    );
  }

  public function getFieldsNew()
  {
    return array(
      'id' => array(),
      'first_name' => array(),
      'last_name' => array(),
      'email_address' => array(),
      'username' => array(),
      'algorithm' => array(),
      'salt' => array(),
      'password' => array(),
      'is_active' => array(),
      'is_banned' => array(),
      'is_super_admin' => array(),
      'last_login' => array(),
      'password_expired' => array(),
      'created_at' => array(),
      'updated_at' => array(),
      'groups_list' => array(),
      'permissions_list' => array(),
      'teams_list' => array(),
      'message_centers_list' => array(),
      'internal_messages_list' => array(),
      'internal_categories_through_internal_message_category_list' => array(),
      'users_list' => array(),
    );
  }


  public function getFormLevels()
  {
      return false;
  }
  
  public function forceRenderLevels()
  {
    return false;
  }
  
  public function getPassParameters()
  {
      return array();
  }
  
  public function getRoutePrefix()
  {
      return 'users';
  }

  public function getFilterDefaults()
  {
    return array(
    );
  }
  
  public function getFilterFormLevels(sfForm $form)
  {
    $fields = $this->getFormFilterFields($form);
    $fields = array_keys($fields);
    $fields = array_diff($fields, $form->getHiddenFields());
    
    return array_chunk($fields, $this->getFilterMaxPerLevel());
  }
  
  public function getFilterMaxPerLevel()
  {
    return 2;
  }
  
   public function getFilterFormWithoutCSRF($filters)
  {
    $class = $this->getFilterFormClass();

    return new $class($filters, $this->getFilterFormOptions(), false);
  }
  public function getFormClass()
  {
    return 'sfGuardUserForm';
  }

  public function hasFilterForm()
  {
    return false;
  }

  /**
   * Gets the filter form class name
   *
   * @return string The filter form class name associated with this generator
   */
  public function getFilterFormClass()
  {
    return 'sfGuardUserFormFilter';
  }

  public function getPagerClass()
  {
    return 'artDoctrinePager';
  }

  public function getPagerMaxPerPage()
  {
    if (isset($_COOKIE[sfConfig::get('sf_app') . '_users_max_per_page']))
      return $_COOKIE[sfConfig::get('sf_app') . '_users_max_per_page'];
  
    return sfContext::getInstance()->getUser()->getAttribute(sfConfig::get('sf_app') . '_max_per_page', 10, 'users');
  }
  
  public function setPagerMaxPerPage($value)
  {
    if (is_int(intval($value)) && in_array($value, $this->getMaxPerPageList()))
    {
      sfContext::getInstance()->setAttribute(sfConfig::get('sf_app') . '_max_per_page', $value, 'users');
      setcookie(sfConfig::get('sf_app') . '_users_max_per_page', $value);
    }
  }
  
  public function getMaxPerPageList()
  {
    return array(  0 => 10,  1 => 20,  2 => 50,);
  }
  
  public function getMaxPerPageStyle()
  {
    return false; //select or list
  }
  
  public function isAjaxPaginator()
  {
    return false;
  }
  
  public function isAppendPagination()
  {
    return false;
  }
  
  public function getAjaxPaginationStyle()
  {
    return 'left-right';
  }

  public function getDefaultSort()
  {
    return array(null, null);
  }

  public function isValidSortColumn($column)
  {
    $fields = $this->getFieldsDefault();

    if (isset($fields[$column]['sort']))
    {
      $sortOptions = $fields[$column]['sort'];
      
      if (isset($sortOptions['custom_function']))
        return true;
        
      $model = $sortOptions['model'];
      $column = isset($sortOptions['columns']) ?$sortOptions['columns'][0] : $sortOptions['column'];
      
      if (isset($sortOptions['model_translation_prefix']))
        return Doctrine_Core::getTable($model)->hasI18nColumn($column);
    }
    else
      $model = 'sfGuardUser';
      
    return Doctrine_Core::getTable($model)->hasColumn($column);
  }
  
  public function isAjaxSorting()
  {
    return false;
  }

  public function getAjaxSortingStyle()
  {
    return 'top-bottom';
  }
  
  public function getTableMethod()
  {
    return 'getTeacherUsers';
  }

  public function getTableCountMethod()
  {
    return '';
  }
  
  public function getFollowParametersString($source)
  {
    if (is_null($this->followParametersString))
      $this->setFollowParametersStrings($source);
      
    return $this->followParametersString;
  }
  
  public function getFollowParametersStringWithQuestionMark($source)
  {
    if (is_null($this->followParametersStringWithQuestionMark))
      $this->setFollowParametersStrings($source);
      
    return $this->followParametersStringWithQuestionMark;
  }
  
  protected function setFollowParametersStrings($source)
  {
    if ($source instanceof sfOutputEscaperObjectDecorator)
      $source = $source->getRawValue();
      
    foreach ($this->getPassParameters() as $i => $param)
    {
      $value = '';
      
      if (is_array($source))
        $value = isset($source[$param]) ? $source[$param] : '';
      else if ($source instanceof sfWebRequest)
        $value = $source->getParameter($param, '');

      if ($value != '')
        $this->followParametersString .= '&' . $param . '=' . $value;
    }

    if (!is_null($this->followParametersString))
      $this->followParametersStringWithQuestionMark = '?' . substr($this->followParametersString, 1);
    else
      $this->followParametersStringWithQuestionMark = '';
  }
  
  public function getActionsPositions()
  {
        return array(  0 => 'bottom',);
  }
  
    public function getBottomFormActionsPosition()
  {
    return '~';
  }
    public function getTopFormActionsPosition()
  {
    return array();
  }
}
