<?php
require_once dirname(__FILE__) . '/../../lib/autoload/sfCoreAutoload.class.php';

//if( ! ini_get('date.timezone') )
//{
//   date_default_timezone_set('GMT');
//}

sfCoreAutoload::register();

class ProjectConfiguration extends sfProjectConfiguration {

  public function __construct($rootDir = null, sfEventDispatcher $dispatcher = null) {
    parent::__construct($rootDir, $dispatcher);

    $this->dispatcher->connect('template.filter_parameters', array($this, 'filterTemplateParameters'));
  }

  public function setup() {
    $this->enablePlugins(array(
        'sfDoctrinePlugin',
        'sfDoctrineGuardPlugin',
        'artMessengerPlugin',
        'artCmsPlugin',
        'artLessPlugin',
        'artLibraryPlugin',
        'artI18nPlugin',
        'artSymfonyPlugin',
        'sfAssetsPlugin'
    ));
  }

  public static function addGameYaml() {

    $configCache = sfApplicationConfiguration::getActive()->getConfigCache();
    $configCache->registerConfigHandler('lib/game/config/game.yml', 'sfDefineEnvironmentConfigHandler', Array('prefix' => 'game_'));
    include $configCache->checkConfig('lib/game/config/game.yml');

    $configCache->registerConfigHandler('lib/game/config/squares.yml', 'sfDefineEnvironmentConfigHandler', Array('prefix' => 'squares_'));
    include $configCache->checkConfig('lib/game/config/squares.yml');
  }

  public function filterTemplateParameters(sfEvent $event, $parameters) {
    artSettings::setTemplatesVars($parameters);

    $context = sfContext::getInstance();
    $user = $context->getUser();

    if ($user->getActiveTeamId()) {
      sfContext::getInstance()->getLogger()->info('filterTemplateParameters init GC');
      $sf_game = HotelGameController::getInstance();
      $parameters['sf_game'] = $sf_game;
    } else {
      $parameters['sf_game'] = false;
    }
    
    
    $user->setAttribute('sf_game', false);

    return $parameters;
  }

  public function configureDoctrine(Doctrine_Manager $manager) {
    sfConfig::set('sf_admin_module_web_dir', '/arteneo-theme');

    $manager->setAttribute(Doctrine_Core::ATTR_TABLE_CLASS, 'artDoctrineTable');
    $manager->setAttribute(Doctrine_Core::ATTR_QUERY_CLASS, 'artDoctrineQuery');
  }

}
