  protected function getFilters()
  {
    $filters = $this->getFilterArrayForParam($this->getFilterParam());
    
    artDebug::logWarning("arteneotheme: filtersAction: getFilters(): filters=".print_r($filters,true));
    artDebug::logWarning("arteneotheme: filtersAction: getFilters(): filtersForceUpdate=".$this->filtersForceUpdate." param=".$this->getFilterParam());
    
    if ($this->filtersForceUpdate)
      return $filters;
        
    return $this->getUser()->getAttribute('filters', $filters, '<?php echo $this->params['route_prefix'] ?>.filters[' . $this->getFilterParam() . ']');
  }

  protected function setFilters(array $filters)
  {
    if (empty($filters) && !isset($this->filtersForceUpdate))
      $filters = $this->getFilterArrayForParam($this->getFilterParam());
    
    artDebug::logWarning("arteneotheme: filtersAction: setFilters(): filters=".print_r($filters,true));
      
    $this->getUser()->setAttribute('filters', $filters, '<?php echo $this->params['route_prefix'] ?>.filters[' . $this->getFilterParam() . ']');
  }

  protected function hasFilters()
  {
    artDebug::logWarning("arteneotheme: filtersAction: hasFilters(): filtersForceUpdate=".$this->filtersForceUpdate);
    if ($this->filtersForceUpdate) 
      return false;
        
    return $this->getUser()->hasAttribute('filters', '<?php echo $this->params['route_prefix'] ?>.filters[' . $this->getFilterParam() . ']') ;
  }

  protected function hasFilterParam()
  {
    return $this->getUser()->hasAttribute('filterParam', '<?php echo $this->params['route_prefix'] ?>') ;
  }
  
  protected function setFilterParam($param)
  {
    $this->getUser()->setAttribute('filterParam', $param, '<?php echo $this->params['route_prefix'] ?>');
  }
  
  protected function getFilterParam()
  {
    return $this->getUser()->getAttribute('filterParam', ' ', '<?php echo $this->params['route_prefix'] ?>');
  }
  
  protected function setFiltersFromLink(array $filters, $param)
  {
    $this->setFilterParam($param);
  
    $this->setFilters($filters);
  }

  protected function hasFiltersFromLink($param)
  {
    return $this->getUser()->hasAttribute('filters', '<?php echo $this->params['route_prefix'] ?>.filters[' . $param . ']') ;
  }
  
  protected function getFilterArrayForParam($param, $defaults = false)
  {
    if (isset ($this->request))
      $paramArray = $this->request->getParameterHolder()->getAll();
    else 
      $paramArray = array();
   
    $linkFilterArray = $this->getLinkFilterArray($paramArray);
    
    if ($defaults === false)
      $defaults = $this->configuration->getFilterDefaults();
      
    $linkArray = artArray::getFromArray($linkFilterArray, $param, $defaults);
    
    artDebug::logWarning("arteneotheme: filtersAction: linkArray=".print_r($linkArray, true));
    
    if (isset ($linkArray['filters-force-update']) && $linkArray['filters-force-update'])
    {
      $this->filtersForceUpdate = true;
      unset($linkArray['filters-force-update']);
    }
      
      
    artDebug::logWarning("arteneotheme: filtersAction: getFilterArrayForParam(): filtersForceUpdate=".$this->filtersForceUpdate);
       
    return $linkArray;
  }
