[?php

/**
 * <?php echo $this->getModuleName() ?> module configuration.
 *
 * @package    ##PROJECT_NAME##
 * @subpackage <?php echo $this->getModuleName()."\n" ?>
 * @author     ##AUTHOR_NAME##
 * @version    SVN: $Id: helper.php 24171 2009-11-19 16:37:50Z Kris.Wallsmith $
 */
abstract class Base<?php echo ucfirst($this->getModuleName()) ?>GeneratorHelper extends sfModelGeneratorHelper
{

  public $configuration;
  public $followParametersString = null;
  public $followParametersStringWithQuestionMark = null;
  
  public function setConfigurationObject($configuration)
  {
    $this->configuration = $configuration;
  }

  public function preLinkTo()
  {
    if (is_null($this->followParametersString))
    {
      $request = sfContext::getInstance()->getRequest();
      $this->followParametersString = $this->configuration->getFollowParametersString($request);
      $this->followParametersStringWithQuestionMark = $this->configuration->getFollowParametersStringWithQuestionMark($request);
    }
  }
  
  public function linkToNew($params)
  {
    $this->preLinkTo();
    artEscaper::setDefaultInArray($params, 'linkParams', array());
    $url =  '@<?php echo $this->params['route_prefix'] ?>_new' . $this->followParametersStringWithQuestionMark;
    return '<li class="sf_admin_action_new">' . link_to(artBox::beginBox('horizontal_span') . __($params['label'], array(), 'sf_admin') . artBox::endBox('horizontal_span'), $url, $params['linkParams']) . '</li>';
  }

  public function linkToEdit($object, $params)
  {
    $this->preLinkTo();
    $url =  '@<?php echo $this->params['route_prefix'] ?>_edit?<?php echo $this->getPrimaryKeys(true) ?>=' . $object->get('<?php echo $this->getPrimaryKeys(true) ?>') . $this->followParametersString;
    return '<li class="sf_admin_action_edit">' . link_to(artBox::beginBox('horizontal_span') . __($params['label'], array(), 'sf_admin') . artBox::endBox('horizontal_span'), $url, $object) . '</li>';
  }

  public function linkToList($params)
  {
    $this->preLinkTo();
    $url =  '@<?php echo $this->params['route_prefix'] ?>'. $this->followParametersStringWithQuestionMark;
    return '<li class="sf_admin_action_list">'.link_to(artBox::beginBox('horizontal_span') . __($params['label'], array(), 'sf_admin') . artBox::endBox('horizontal_span'), $url) . '</li>';
  }  
  
  public function getUrlForAction($action)
  {
    return 'list' == $action ? '<?php echo $this->params['route_prefix'] ?>' : '<?php echo $this->params['route_prefix'] ?>_'.$action;
  }
  
  public function linkToDelete($object, $params)
  {
    //return parent::linkToDelete($object, $params);
    if ($object->isNew())
      return '';
      
    $this->preLinkTo();
    
    $name = artBox::beginBox('horizontal_span') . __($params['label'], array(), 'sf_admin') . artBox::endBox('horizontal_span');
    $url = $this->getUrlForAction('delete');
    $options = array(
      'method' => 'delete', 
      'confirm' => !empty($params['confirm']) ? __($params['confirm'], array(), 'sf_admin') : $params['confirm'],
      'query_string' => substr($this->followParametersString, 1)
    );

    $linkTo = link_to($name, $url, $object, $options);
    
    return '<li class="sf_admin_action_delete">'. $linkTo .'</li>';
  }
  
  public function linkToSave($object, $params)
  {
    $params['value'] = $params['label'];
    
    return '<li class="sf_admin_action_save">' . get_partial('partials/submit', $params) . '</li>';
  }
  
   public function linkToSaveAndAdd($object, $params)
  {
    if (!$object->isNew())
      return '';

    $params['value'] = $params['label'];
    $params['inputName'] = '_save_and_add';
    
    return '<li class="sf_admin_action_save_and_add">' . get_partial('partials/submit', $params) . '</li>';
  }
}
