CREATE TABLE `art_configuration` (`id` INT AUTO_INCREMENT, `name` MEDIUMTEXT NOT NULL, `editable` TINYINT DEFAULT 1 NOT NULL, `widget` MEDIUMTEXT, `validator` MEDIUMTEXT, `renderer` MEDIUMTEXT, `default` MEDIUMTEXT, `order` INT UNIQUE, `created_at` DATETIME NOT NULL, `updated_at` DATETIME NOT NULL, PRIMARY KEY(`id`)) DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci ENGINE = InnoDB;
CREATE TABLE `art_configuration_translation` (`id` INT, `label` VARCHAR(255), `hint` MEDIUMTEXT, `value` MEDIUMTEXT NOT NULL, `lang` CHAR(2), PRIMARY KEY(`id`, `lang`)) DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci ENGINE = InnoDB;
CREATE TABLE `article` (`id` INT AUTO_INCREMENT, `creator_id` BIGINT NOT NULL, `editor_id` BIGINT, `layout_id` INT NOT NULL, `unique_name` VARCHAR(100), `is_displayed` TINYINT DEFAULT 1, `start_at` DATETIME, `expire_at` DATETIME, `flag` MEDIUMTEXT, `title_image` VARCHAR(255), `title_image_label` VARCHAR(255), `big_image` VARCHAR(255), `views` INT, `vote_sum` FLOAT(18, 2), `vote_count` INT, `source` TEXT, `created_at` DATETIME NOT NULL, `updated_at` DATETIME NOT NULL, INDEX `fk_article_sf_guard_user_idx` (`creator_id`), INDEX `fk_article_sf_guard_user1_idx` (`editor_id`), INDEX `fk_article_layout1_idx` (`layout_id`), PRIMARY KEY(`id`)) DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci ENGINE = InnoDB;
CREATE TABLE `article_translation` (`id` INT, `title` VARCHAR(255) NOT NULL, `description` MEDIUMTEXT NOT NULL, `short_description` TEXT, `meta_title` VARCHAR(255), `meta_description` TEXT, `meta_keywords` TEXT, `lang` CHAR(2), `slug` VARCHAR(255), UNIQUE INDEX `article_translation_sluggable_idx` (`slug`, `lang`, `title`), PRIMARY KEY(`id`, `lang`)) DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci ENGINE = InnoDB;
CREATE TABLE `article_translation_index` (`keyword` VARCHAR(200), `field` VARCHAR(50), `position` BIGINT, `id` INT, `lang` CHAR(2), PRIMARY KEY(`keyword`, `field`, `position`, `id`, `lang`)) DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci ENGINE = InnoDB;
CREATE TABLE `article_index` (`keyword` VARCHAR(200), `field` VARCHAR(50), `position` BIGINT, `id` INT, PRIMARY KEY(`keyword`, `field`, `position`, `id`)) DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci ENGINE = InnoDB;
CREATE TABLE `article_article_blog_category` (`article_blog_category_id` INT, `article_id` INT, `created_at` DATETIME NOT NULL, `updated_at` DATETIME NOT NULL, INDEX `fk_article_article_blog_category_article_blog_category_idx` (`article_blog_category_id`), INDEX `fk_article_article_blog_category_article1_idx` (`article_id`), PRIMARY KEY(`article_blog_category_id`, `article_id`)) DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci ENGINE = InnoDB;
CREATE TABLE `article_blog_category` (`id` INT AUTO_INCREMENT, `created_at` DATETIME NOT NULL, `updated_at` DATETIME NOT NULL, PRIMARY KEY(`id`)) DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci ENGINE = InnoDB;
CREATE TABLE `article_blog_category_translation` (`id` INT, `name` TEXT, `lang` CHAR(2), PRIMARY KEY(`id`, `lang`)) DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci ENGINE = InnoDB;
CREATE TABLE `article_article_category` (`id` BIGINT AUTO_INCREMENT, `category_id` INT NOT NULL, `article_id` INT, `subcategory_id` INT, `order` INT DEFAULT 0 NOT NULL, `created_at` DATETIME NOT NULL, `updated_at` DATETIME NOT NULL, INDEX `fk_article_category_category1_idx` (`category_id`), INDEX `fk_article_category_article1_idx` (`article_id`), INDEX `fk_article_category_category2_idx` (`subcategory_id`), PRIMARY KEY(`id`)) DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci ENGINE = InnoDB;
CREATE TABLE `article_comment` (`id` INT AUTO_INCREMENT, `article_id` INT NOT NULL, `user_id` BIGINT, `parent_article_comment_id` INT, `text` MEDIUMTEXT NOT NULL, `display` TINYINT(1) DEFAULT '1' NOT NULL, `nick` VARCHAR(100), `email` VARCHAR(255), `www` VARCHAR(255), `gg` VARCHAR(45), `notify` TINYINT(1) DEFAULT '0', `created_at` DATETIME NOT NULL, `updated_at` DATETIME NOT NULL, INDEX `fk_article_comment_article1_idx` (`article_id`), INDEX `fk_article_comment_sf_guard_user1_idx` (`user_id`), INDEX `fk_article_comment_article_comment1_idx` (`parent_article_comment_id`), PRIMARY KEY(`id`)) DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci ENGINE = InnoDB;
CREATE TABLE `article_file` (`id` INT AUTO_INCREMENT, `article_id` INT NOT NULL, `file` TEXT NOT NULL, `original_filename` TEXT NOT NULL, `icon` VARCHAR(255), `order` INT DEFAULT 0, `created_at` DATETIME NOT NULL, `updated_at` DATETIME NOT NULL, INDEX `fk_article_file_article1_idx` (`article_id`), PRIMARY KEY(`id`)) DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci ENGINE = InnoDB;
CREATE TABLE `article_file_translation` (`id` INT, `title` VARCHAR(255), `description` MEDIUMTEXT, `lang` CHAR(2), PRIMARY KEY(`id`, `lang`)) DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci ENGINE = InnoDB;
CREATE TABLE `article_group` (`article_id` INT, `group_id` BIGINT, INDEX `fk_article_group_article1_idx` (`article_id`), INDEX `fk_article_group_sf_guard_group1_idx` (`group_id`), PRIMARY KEY(`article_id`, `group_id`)) DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci ENGINE = InnoDB;
CREATE TABLE `article_permission` (`article_id` INT, `permission_id` BIGINT, INDEX `fk_article_permission_article1_idx` (`article_id`), INDEX `fk_article_permission_sf_guard_permission1_idx` (`permission_id`), PRIMARY KEY(`article_id`, `permission_id`)) DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci ENGINE = InnoDB;
CREATE TABLE `article_photo` (`id` INT AUTO_INCREMENT, `article_id` INT NOT NULL, `original_image` VARCHAR(100), `small_image` VARCHAR(100), `medium_image` VARCHAR(100), `big_image` VARCHAR(100), `order` INT DEFAULT 1, `created_at` DATETIME NOT NULL, `updated_at` DATETIME NOT NULL, INDEX `fk_article_photo_article1_idx` (`article_id`), PRIMARY KEY(`id`)) DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci ENGINE = InnoDB;
CREATE TABLE `article_photo_translation` (`id` INT, `title` VARCHAR(255), `description` MEDIUMTEXT, `lang` CHAR(2), PRIMARY KEY(`id`, `lang`)) DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci ENGINE = InnoDB;
CREATE TABLE `article_article_tag` (`article_id` INT, `tag_id` INT, INDEX `fk_article_tag_article1_idx` (`article_id`), INDEX `fk_article_tag_tag1_idx` (`tag_id`), PRIMARY KEY(`article_id`, `tag_id`)) DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci ENGINE = InnoDB;
CREATE TABLE `friend_blacklist` (`user_id` BIGINT, `ignored_user_id` BIGINT, INDEX `fk_sf_guard_user_has_sf_guard_user_sf_guard_user2_idx` (`ignored_user_id`), INDEX `fk_sf_guard_user_has_sf_guard_user_sf_guard_user1_idx` (`user_id`), PRIMARY KEY(`user_id`, `ignored_user_id`)) DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci ENGINE = InnoDB;
CREATE TABLE `article_category` (`id` INT AUTO_INCREMENT, `title_image` VARCHAR(255), `unique_name` VARCHAR(100), `image_count` INT DEFAULT 1, PRIMARY KEY(`id`)) DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci ENGINE = InnoDB;
CREATE TABLE `article_category_translation` (`id` INT, `name` VARCHAR(100) NOT NULL, `description` TEXT, `lang` CHAR(2), PRIMARY KEY(`id`, `lang`)) DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci ENGINE = InnoDB;
CREATE TABLE `class_has_user` (`class_id` BIGINT, `user_id` BIGINT, INDEX `fk_class_has_sf_guard_user_sf_guard_user1_idx` (`user_id`), INDEX `fk_class_has_sf_guard_user_class1_idx` (`class_id`), PRIMARY KEY(`class_id`, `user_id`)) DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci ENGINE = InnoDB;
CREATE TABLE `friend` (`id` BIGINT AUTO_INCREMENT, `user_id` BIGINT NOT NULL, `friend_id` BIGINT, `accepted` TINYINT DEFAULT 0, `mail` VARCHAR(100), `created_at` DATETIME NOT NULL, `updated_at` DATETIME NOT NULL, INDEX `fk_friend_sf_guard_user1_idx` (`user_id`), INDEX `fk_friend_sf_guard_user2_idx` (`friend_id`), PRIMARY KEY(`id`)) DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci ENGINE = InnoDB;
CREATE TABLE `game` (`id` BIGINT AUTO_INCREMENT, `teacher_id` BIGINT NOT NULL, `name` VARCHAR(255) NOT NULL, `status` TINYINT DEFAULT 0 NOT NULL, `game_data_json` LONGTEXT, `game_controller_class` VARCHAR(125), `created_at` DATETIME NOT NULL, `updated_at` DATETIME NOT NULL, INDEX `fk_game_sf_guard_user1_idx` (`teacher_id`), PRIMARY KEY(`id`)) DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci ENGINE = InnoDB;
CREATE TABLE `game_teacher_permission` (`id` BIGINT AUTO_INCREMENT, `sf_guard_user_permission_id` BIGINT NOT NULL, `game_id` BIGINT NOT NULL, `teacher_id` BIGINT NOT NULL, INDEX `fk_game_teacher_permission_sf_guard_user_permission1_idx` (`sf_guard_user_permission_id`), INDEX `fk_game_teacher_permission_game1_idx` (`game_id`), INDEX `fk_game_teacher_permission_sf_guard_user1_idx` (`teacher_id`), UNIQUE INDEX `unique_game_teacher_permission_idx` (`sf_guard_user_permission_id` ASC, `game_id` ASC, `teacher_id` ASC), PRIMARY KEY(`id`)) DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci ENGINE = InnoDB;
CREATE TABLE `guard_user_tag` (`id` INT AUTO_INCREMENT, `created_at` DATETIME NOT NULL, `updated_at` DATETIME NOT NULL, `deleted_at` DATETIME, PRIMARY KEY(`id`)) DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci ENGINE = InnoDB;
CREATE TABLE `internal_category` (`id` BIGINT AUTO_INCREMENT, `user_id` BIGINT, `name` VARCHAR(45) NOT NULL, `order` TINYINT DEFAULT 1, `created_at` DATETIME NOT NULL, `updated_at` DATETIME NOT NULL, INDEX `fk_internal_category_sf_guard_user1_idx` (`user_id`), PRIMARY KEY(`id`)) DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci ENGINE = InnoDB;
CREATE TABLE `internal_conversation` (`id` INT AUTO_INCREMENT, `title` VARCHAR(255), PRIMARY KEY(`id`)) DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci ENGINE = InnoDB;
CREATE TABLE `internal_message` (`id` BIGINT AUTO_INCREMENT, `internal_conversation_id` INT, `author_id` BIGINT, `receiver_id` BIGINT, `is_readed` TINYINT DEFAULT 0, `title` VARCHAR(255), `description` MEDIUMTEXT, `created_at` DATETIME NOT NULL, `updated_at` DATETIME NOT NULL, INDEX `fk_internal_message_sf_guard_user1_idx` (`author_id`), INDEX `fk_internal_message_sf_guard_user2_idx` (`receiver_id`), INDEX `fk_internal_message_internal_conversation1_idx` (`internal_conversation_id`), PRIMARY KEY(`id`)) DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci ENGINE = InnoDB;
CREATE TABLE `internal_message_category` (`internal_message_id` BIGINT, `internal_category_id` BIGINT, `user_id` BIGINT, INDEX `fk_internal_message_has_internal_category_internal_category1_idx` (`internal_category_id`), INDEX `fk_internal_message_has_internal_category_internal_message1_idx` (`internal_message_id`), INDEX `fk_internal_message_internal_category_sf_guard_user1_idx` (`user_id`), PRIMARY KEY(`internal_message_id`, `internal_category_id`, `user_id`)) DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci ENGINE = InnoDB;
CREATE TABLE `invitation` (`id` INT AUTO_INCREMENT, `inviter_id` BIGINT NOT NULL, `email` VARCHAR(255), `click_count` INT DEFAULT 0, `created_at` DATETIME NOT NULL, `updated_at` DATETIME NOT NULL, INDEX `fk_invitation_sf_guard_user_idx` (`inviter_id`), PRIMARY KEY(`id`)) DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci ENGINE = InnoDB;
CREATE TABLE `layout` (`id` INT AUTO_INCREMENT, `module_id` INT NOT NULL, `name` VARCHAR(100), `html` MEDIUMTEXT, `view` VARCHAR(100), INDEX `fk_layout_module1_idx` (`module_id`), PRIMARY KEY(`id`)) DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci ENGINE = InnoDB;
CREATE TABLE `layout_layout_param` (`layout_id` INT, `param_id` INT, `value` VARCHAR(100), INDEX `fk_layout_param_param1_idx` (`param_id`), INDEX `fk_layout_param_layout_idx` (`layout_id`), PRIMARY KEY(`layout_id`, `param_id`)) DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci ENGINE = InnoDB;
CREATE TABLE `log_decision` (`id` BIGINT AUTO_INCREMENT, `round_id` BIGINT NOT NULL, `user_id` BIGINT NOT NULL, `decision` VARCHAR(255) NOT NULL, `old_value` MEDIUMTEXT, `new_value` MEDIUMTEXT, `created_at` DATETIME NOT NULL, INDEX `fk_decision_round1_idx` (`round_id`), INDEX `fk_decision_sf_guard_user1_idx` (`user_id`), INDEX `fk_decision_decision1_idx` (`decision`), PRIMARY KEY(`id`)) DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci ENGINE = InnoDB;
CREATE TABLE `log_event` (`id` BIGINT AUTO_INCREMENT, `team_id` BIGINT, `user_id` BIGINT, `round_id` BIGINT, `event` VARCHAR(255), `text` MEDIUMTEXT, `value` MEDIUMTEXT, `created_at` DATETIME NOT NULL, INDEX `fk_item_displayed_sf_guard_user1_idx` (`user_id`), INDEX `fk_item_item1_idx` (`event`), INDEX `fk_log_event_round1_idx` (`round_id`), INDEX `fk_log_event_team1_idx` (`team_id`), PRIMARY KEY(`id`)) DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci ENGINE = InnoDB;
CREATE TABLE `log_message_displayed` (`id` BIGINT AUTO_INCREMENT, `message_id` BIGINT NOT NULL, `created_at` DATETIME NOT NULL, INDEX `fk_table1_messages1_idx` (`message_id`), PRIMARY KEY(`id`)) DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci ENGINE = InnoDB;
CREATE TABLE `message` (`id` BIGINT AUTO_INCREMENT, `team_id` BIGINT NOT NULL, `user_id` BIGINT NOT NULL, `round_id` BIGINT, `status` TINYINT DEFAULT 0 NOT NULL, `title` MEDIUMTEXT, `category` VARCHAR(255), `body` MEDIUMTEXT, `created_at` DATETIME NOT NULL, INDEX `fk_game_article_user_team1_idx` (`team_id`), INDEX `fk_game_article_user_user1_idx` (`user_id`), INDEX `fk_game_article_user_round1_idx` (`round_id`), INDEX `unique_article_game_user_idx` (`team_id` ASC, `user_id` ASC), PRIMARY KEY(`id`)) DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci ENGINE = InnoDB;
CREATE TABLE `message_center` (`id` INT AUTO_INCREMENT, `message_channel_id` INT NOT NULL, `layout_id` INT, `collector_class` VARCHAR(100) NOT NULL, `newsletter` TINYINT DEFAULT 0, `unique_name` VARCHAR(45), `created_at` DATETIME NOT NULL, `updated_at` DATETIME NOT NULL, INDEX `fk_message_center_message_channel_idx` (`message_channel_id`), INDEX `fk_message_center_layout1_idx` (`layout_id`), PRIMARY KEY(`id`)) DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci ENGINE = InnoDB;
CREATE TABLE `message_center_file` (`id` INT AUTO_INCREMENT, `message_center_id` INT NOT NULL, `file` TEXT NOT NULL, `original_filename` TEXT NOT NULL, `order` INT DEFAULT 0, INDEX `fk_message_center_file_message_center1_idx` (`message_center_id`), PRIMARY KEY(`id`)) DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci ENGINE = InnoDB;
CREATE TABLE `message_center_file_translation` (`id` INT, `title` VARCHAR(255), `description` MEDIUMTEXT, `lang` CHAR(2), PRIMARY KEY(`id`, `lang`)) DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci ENGINE = InnoDB;
CREATE TABLE `message_channel` (`id` INT AUTO_INCREMENT, `channel` VARCHAR(45), `channel_class` VARCHAR(45), PRIMARY KEY(`id`)) DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci ENGINE = InnoDB;
CREATE TABLE `message_multisend_history` (`id` INT AUTO_INCREMENT, `message_center_id` INT NOT NULL, `message_multisend_type_id` INT NOT NULL, `user_id` BIGINT, `newsletter_user_id` INT, `title` TEXT NOT NULL, `description` MEDIUMTEXT NOT NULL, `status` TINYINT, `error` TEXT, `created_at` DATETIME NOT NULL, `updated_at` DATETIME NOT NULL, INDEX `fk_message_multisend_history_sf_guard_user1_idx` (`user_id`), INDEX `fk_message_multisend_history_newsletter_user1_idx` (`newsletter_user_id`), INDEX `fk_message_multisend_history_message_center1_idx` (`message_center_id`), INDEX `fk_message_multisend_history_message_multisend_type1_idx` (`message_multisend_type_id`), PRIMARY KEY(`id`)) DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci ENGINE = InnoDB;
CREATE TABLE `message_multisend_list` (`id` INT AUTO_INCREMENT, `message_center_id` INT NOT NULL, `message_multisend_type_id` INT NOT NULL, `user_id` BIGINT, `newsletter_user_id` INT, `created_at` DATETIME NOT NULL, `updated_at` DATETIME NOT NULL, INDEX `fk_message_multisend_list_sf_guard_user1_idx` (`user_id`), INDEX `fk_message_multisend_list_newsletter_user1_idx` (`newsletter_user_id`), INDEX `fk_message_multisend_list_message_center1_idx` (`message_center_id`), INDEX `fk_message_multisend_list_message_multisend_type1_idx` (`message_multisend_type_id`), PRIMARY KEY(`id`)) DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci ENGINE = InnoDB;
CREATE TABLE `message_multisend_type` (`id` INT AUTO_INCREMENT, `name` VARCHAR(100), PRIMARY KEY(`id`)) DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci ENGINE = InnoDB;
CREATE TABLE `message_template` (`id` INT AUTO_INCREMENT, `message_center_id` INT NOT NULL, `order` INT, `created_at` DATETIME NOT NULL, `updated_at` DATETIME NOT NULL, INDEX `fk_message_template_message_center1_idx` (`message_center_id`), PRIMARY KEY(`id`)) DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci ENGINE = InnoDB;
CREATE TABLE `message_template_translation` (`id` INT, `title` MEDIUMTEXT, `description` MEDIUMTEXT, `lang` CHAR(2), PRIMARY KEY(`id`, `lang`)) DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci ENGINE = InnoDB;
CREATE TABLE `layout_module` (`id` INT AUTO_INCREMENT, `name` VARCHAR(100), PRIMARY KEY(`id`)) DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci ENGINE = InnoDB;
CREATE TABLE `newsletter_user` (`id` INT AUTO_INCREMENT, `user_id` BIGINT UNIQUE, `email` VARCHAR(100) UNIQUE, `first_name` VARCHAR(100), `last_name` VARCHAR(100), `status` TINYINT DEFAULT 0, `message_count` INT DEFAULT 0, `created_at` DATETIME NOT NULL, `updated_at` DATETIME NOT NULL, INDEX `fk_newsletter_user_sf_guard_user1_idx` (`user_id`), PRIMARY KEY(`id`)) DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci ENGINE = InnoDB;
CREATE TABLE `newsletter_user_tag` (`id` INT AUTO_INCREMENT, `created_at` DATETIME NOT NULL, `updated_at` DATETIME NOT NULL, `deleted_at` DATETIME, PRIMARY KEY(`id`)) DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci ENGINE = InnoDB;
CREATE TABLE `layout_param` (`id` INT AUTO_INCREMENT, `module_id` INT NOT NULL, `unique_name` VARCHAR(100), `validator` MEDIUMTEXT, `widget` MEDIUMTEXT, `default` MEDIUMTEXT, `editable` TINYINT DEFAULT 0, INDEX `fk_param_module1_idx` (`module_id`), PRIMARY KEY(`id`)) DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci ENGINE = InnoDB;
CREATE TABLE `article_preferred_article` (`article_id` INT, `preferred_id` INT, INDEX `fk_preferred_article_article1_idx` (`article_id`), INDEX `fk_preferred_article_article2_idx` (`preferred_id`), PRIMARY KEY(`article_id`, `preferred_id`)) DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci ENGINE = InnoDB;
CREATE TABLE `round` (`id` BIGINT AUTO_INCREMENT, `team_id` BIGINT NOT NULL, `round_number` INT NOT NULL, `status` TINYINT DEFAULT 0 NOT NULL, `name` VARCHAR(255), `round_data_json` LONGTEXT, `round_decision_data_json` LONGTEXT, `round_raport_data_json` LONGTEXT, `created_at` DATETIME NOT NULL, INDEX `fk_round_team1_idx` (`team_id`), UNIQUE INDEX `unique_round_team_idx` (`team_id` ASC, `round_number` ASC), PRIMARY KEY(`id`)) DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci ENGINE = InnoDB;
CREATE TABLE `article_tag` (`id` INT AUTO_INCREMENT, PRIMARY KEY(`id`)) DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci ENGINE = InnoDB;
CREATE TABLE `article_tag_translation` (`id` INT, `name` VARCHAR(255) NOT NULL, `lang` CHAR(2), PRIMARY KEY(`id`, `lang`)) DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci ENGINE = InnoDB;
CREATE TABLE `teacher_class` (`id` BIGINT AUTO_INCREMENT, `teacher_id` BIGINT NOT NULL, `name` VARCHAR(255) NOT NULL, `status` TINYINT DEFAULT 1 NOT NULL, INDEX `fk_class_sf_guard_user1_idx` (`teacher_id`), PRIMARY KEY(`id`)) DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci ENGINE = InnoDB;
CREATE TABLE `team` (`id` BIGINT AUTO_INCREMENT, `game_id` BIGINT NOT NULL, `name` VARCHAR(255) NOT NULL, `logo` VARCHAR(255), INDEX `fk_team_game1_idx` (`game_id`), PRIMARY KEY(`id`)) DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci ENGINE = InnoDB;
CREATE TABLE `user_detail` (`id` BIGINT, `school` VARCHAR(255), `phone` VARCHAR(45), `status` TINYINT, INDEX `fk_user_detail_sf_guard_user_idx` (`id`), PRIMARY KEY(`id`)) DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci ENGINE = InnoDB;
CREATE TABLE `user_message_settings` (`id` BIGINT AUTO_INCREMENT, `message_center_id` INT NOT NULL, `user_id` BIGINT, `enabled` TINYINT DEFAULT 1, `created_at` DATETIME NOT NULL, `updated_at` DATETIME NOT NULL, INDEX `fk_message_center_message_channel_message_center1_idx` (`message_center_id`), INDEX `fk_message_center_message_channel_sf_guard_user1_idx` (`user_id`), PRIMARY KEY(`id`)) DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci ENGINE = InnoDB;
CREATE TABLE `user_tag` (`id` INT AUTO_INCREMENT, PRIMARY KEY(`id`)) DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci ENGINE = InnoDB;
CREATE TABLE `user_has_team` (`user_id` BIGINT, `team_id` BIGINT, `role` VARCHAR(255), INDEX `fk_sf_guard_user_has_team_team1_idx` (`team_id`), INDEX `fk_sf_guard_user_has_team_sf_guard_user1_idx` (`user_id`), PRIMARY KEY(`user_id`, `team_id`)) DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci ENGINE = InnoDB;
CREATE TABLE `i18n_category` (`cat_id` BIGINT AUTO_INCREMENT, `name` VARCHAR(100) NOT NULL, `created_at` DATETIME NOT NULL, `updated_at` DATETIME NOT NULL, PRIMARY KEY(`cat_id`)) DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci ENGINE = INNODB;
CREATE TABLE `i18n_translations` (`id` BIGINT AUTO_INCREMENT, `cat_id` BIGINT NOT NULL, `source` LONGTEXT NOT NULL, `target` LONGTEXT NOT NULL, `comments` LONGTEXT, `created_at` DATETIME NOT NULL, `updated_at` DATETIME NOT NULL, `translated` TINYINT(1) DEFAULT '1', INDEX `cat_id_idx` (`cat_id`), PRIMARY KEY(`id`)) DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci ENGINE = INNODB;
CREATE TABLE `sf_guard_forgot_password` (`id` BIGINT AUTO_INCREMENT, `user_id` BIGINT NOT NULL, `unique_key` VARCHAR(255), `expires_at` DATETIME NOT NULL, `created_at` DATETIME NOT NULL, `updated_at` DATETIME NOT NULL, INDEX `user_id_idx` (`user_id`), PRIMARY KEY(`id`)) DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci ENGINE = INNODB;
CREATE TABLE `sf_guard_group` (`id` BIGINT AUTO_INCREMENT, `name` VARCHAR(255) UNIQUE, `description` TEXT, `password_expiration_period` datetime, `created_at` DATETIME NOT NULL, `updated_at` DATETIME NOT NULL, PRIMARY KEY(`id`)) DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci ENGINE = InnoDB;
CREATE TABLE `sf_guard_group_permission` (`group_id` BIGINT, `permission_id` BIGINT, `created_at` DATETIME NOT NULL, `updated_at` DATETIME NOT NULL, PRIMARY KEY(`group_id`, `permission_id`)) DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci ENGINE = INNODB;
CREATE TABLE `sf_guard_permission` (`id` BIGINT AUTO_INCREMENT, `name` VARCHAR(255) UNIQUE, `description` TEXT, `created_at` DATETIME NOT NULL, `updated_at` DATETIME NOT NULL, PRIMARY KEY(`id`)) DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci ENGINE = InnoDB;
CREATE TABLE `sf_guard_remember_key` (`id` BIGINT AUTO_INCREMENT, `user_id` BIGINT, `remember_key` VARCHAR(32), `ip_address` VARCHAR(50), `created_at` DATETIME NOT NULL, `updated_at` DATETIME NOT NULL, INDEX `user_id_idx` (`user_id`), PRIMARY KEY(`id`)) DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci ENGINE = INNODB;
CREATE TABLE `sf_guard_user` (`id` BIGINT AUTO_INCREMENT, `first_name` VARCHAR(255), `last_name` VARCHAR(255), `email_address` VARCHAR(255) NOT NULL UNIQUE, `username` VARCHAR(128) NOT NULL UNIQUE, `algorithm` VARCHAR(128) DEFAULT 'sha1' NOT NULL, `salt` VARCHAR(128), `password` VARCHAR(128), `is_active` TINYINT(1) DEFAULT '0', `is_banned` TINYINT(1) DEFAULT '0', `is_super_admin` TINYINT(1) DEFAULT '0', `last_login` DATETIME, `password_expired` DATETIME, `created_at` DATETIME NOT NULL, `updated_at` DATETIME NOT NULL, INDEX `is_active_idx_idx` (`is_active`), PRIMARY KEY(`id`)) DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci ENGINE = InnoDB;
CREATE TABLE `sf_guard_user_index` (`keyword` VARCHAR(200), `field` VARCHAR(50), `position` BIGINT, `id` BIGINT, PRIMARY KEY(`keyword`, `field`, `position`, `id`)) DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci ENGINE = InnoDB;
CREATE TABLE `sf_guard_user_group` (`user_id` BIGINT, `group_id` BIGINT, `created_at` DATETIME NOT NULL, `updated_at` DATETIME NOT NULL, PRIMARY KEY(`user_id`, `group_id`)) DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci ENGINE = INNODB;
CREATE TABLE `sf_guard_user_permission` (`user_id` BIGINT, `permission_id` BIGINT, `created_at` DATETIME NOT NULL, `updated_at` DATETIME NOT NULL, PRIMARY KEY(`user_id`, `permission_id`)) DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci ENGINE = INNODB;
ALTER TABLE `art_configuration_translation` ADD CONSTRAINT `art_configuration_translation_id_art_configuration_id` FOREIGN KEY (`id`) REFERENCES `art_configuration`(`id`) ON UPDATE CASCADE ON DELETE CASCADE;
ALTER TABLE `article` ADD CONSTRAINT `article_layout_id_layout_id` FOREIGN KEY (`layout_id`) REFERENCES `layout`(`id`) ON UPDATE CASCADE ON DELETE CASCADE;
ALTER TABLE `article` ADD CONSTRAINT `article_editor_id_sf_guard_user_id` FOREIGN KEY (`editor_id`) REFERENCES `sf_guard_user`(`id`) ON UPDATE CASCADE ON DELETE CASCADE;
ALTER TABLE `article` ADD CONSTRAINT `article_creator_id_sf_guard_user_id` FOREIGN KEY (`creator_id`) REFERENCES `sf_guard_user`(`id`) ON UPDATE CASCADE ON DELETE CASCADE;
ALTER TABLE `article_translation` ADD CONSTRAINT `article_translation_id_article_id` FOREIGN KEY (`id`) REFERENCES `article`(`id`) ON UPDATE CASCADE ON DELETE CASCADE;
ALTER TABLE `article_translation_index` ADD CONSTRAINT `article_translation_index_id_article_translation_id` FOREIGN KEY (`id`) REFERENCES `article_translation`(`id`) ON UPDATE CASCADE ON DELETE CASCADE;
ALTER TABLE `article_index` ADD CONSTRAINT `article_index_id_article_id` FOREIGN KEY (`id`) REFERENCES `article`(`id`) ON UPDATE CASCADE ON DELETE CASCADE;
ALTER TABLE `article_article_blog_category` ADD CONSTRAINT `article_article_blog_category_article_id_article_id` FOREIGN KEY (`article_id`) REFERENCES `article`(`id`) ON UPDATE CASCADE ON DELETE CASCADE;
ALTER TABLE `article_article_blog_category` ADD CONSTRAINT `aaai` FOREIGN KEY (`article_blog_category_id`) REFERENCES `article_blog_category`(`id`) ON UPDATE CASCADE ON DELETE CASCADE;
ALTER TABLE `article_blog_category_translation` ADD CONSTRAINT `article_blog_category_translation_id_article_blog_category_id` FOREIGN KEY (`id`) REFERENCES `article_blog_category`(`id`) ON UPDATE CASCADE ON DELETE CASCADE;
ALTER TABLE `article_article_category` ADD CONSTRAINT `article_article_category_subcategory_id_article_category_id` FOREIGN KEY (`subcategory_id`) REFERENCES `article_category`(`id`) ON UPDATE CASCADE ON DELETE CASCADE;
ALTER TABLE `article_article_category` ADD CONSTRAINT `article_article_category_category_id_article_category_id` FOREIGN KEY (`category_id`) REFERENCES `article_category`(`id`) ON UPDATE CASCADE ON DELETE CASCADE;
ALTER TABLE `article_article_category` ADD CONSTRAINT `article_article_category_article_id_article_id` FOREIGN KEY (`article_id`) REFERENCES `article`(`id`) ON UPDATE CASCADE ON DELETE CASCADE;
ALTER TABLE `article_comment` ADD CONSTRAINT `article_comment_user_id_sf_guard_user_id` FOREIGN KEY (`user_id`) REFERENCES `sf_guard_user`(`id`) ON UPDATE CASCADE ON DELETE CASCADE;
ALTER TABLE `article_comment` ADD CONSTRAINT `article_comment_parent_article_comment_id_article_comment_id` FOREIGN KEY (`parent_article_comment_id`) REFERENCES `article_comment`(`id`) ON UPDATE CASCADE ON DELETE CASCADE;
ALTER TABLE `article_comment` ADD CONSTRAINT `article_comment_article_id_article_id` FOREIGN KEY (`article_id`) REFERENCES `article`(`id`) ON UPDATE CASCADE ON DELETE CASCADE;
ALTER TABLE `article_file` ADD CONSTRAINT `article_file_article_id_article_id` FOREIGN KEY (`article_id`) REFERENCES `article`(`id`) ON UPDATE CASCADE ON DELETE CASCADE;
ALTER TABLE `article_file_translation` ADD CONSTRAINT `article_file_translation_id_article_file_id` FOREIGN KEY (`id`) REFERENCES `article_file`(`id`) ON UPDATE CASCADE ON DELETE CASCADE;
ALTER TABLE `article_group` ADD CONSTRAINT `article_group_group_id_sf_guard_group_id` FOREIGN KEY (`group_id`) REFERENCES `sf_guard_group`(`id`) ON UPDATE CASCADE ON DELETE CASCADE;
ALTER TABLE `article_group` ADD CONSTRAINT `article_group_article_id_article_id` FOREIGN KEY (`article_id`) REFERENCES `article`(`id`) ON UPDATE CASCADE ON DELETE CASCADE;
ALTER TABLE `article_permission` ADD CONSTRAINT `article_permission_permission_id_sf_guard_permission_id` FOREIGN KEY (`permission_id`) REFERENCES `sf_guard_permission`(`id`) ON UPDATE CASCADE ON DELETE CASCADE;
ALTER TABLE `article_permission` ADD CONSTRAINT `article_permission_article_id_article_id` FOREIGN KEY (`article_id`) REFERENCES `article`(`id`) ON UPDATE CASCADE ON DELETE CASCADE;
ALTER TABLE `article_photo` ADD CONSTRAINT `article_photo_article_id_article_id` FOREIGN KEY (`article_id`) REFERENCES `article`(`id`) ON UPDATE CASCADE ON DELETE CASCADE;
ALTER TABLE `article_photo_translation` ADD CONSTRAINT `article_photo_translation_id_article_photo_id` FOREIGN KEY (`id`) REFERENCES `article_photo`(`id`) ON UPDATE CASCADE ON DELETE CASCADE;
ALTER TABLE `article_article_tag` ADD CONSTRAINT `article_article_tag_tag_id_article_tag_id` FOREIGN KEY (`tag_id`) REFERENCES `article_tag`(`id`) ON UPDATE CASCADE ON DELETE CASCADE;
ALTER TABLE `article_article_tag` ADD CONSTRAINT `article_article_tag_article_id_article_id` FOREIGN KEY (`article_id`) REFERENCES `article`(`id`) ON UPDATE CASCADE ON DELETE CASCADE;
ALTER TABLE `friend_blacklist` ADD CONSTRAINT `friend_blacklist_user_id_sf_guard_user_id` FOREIGN KEY (`user_id`) REFERENCES `sf_guard_user`(`id`) ON UPDATE CASCADE ON DELETE CASCADE;
ALTER TABLE `friend_blacklist` ADD CONSTRAINT `friend_blacklist_ignored_user_id_sf_guard_user_id` FOREIGN KEY (`ignored_user_id`) REFERENCES `sf_guard_user`(`id`) ON UPDATE CASCADE ON DELETE CASCADE;
ALTER TABLE `article_category_translation` ADD CONSTRAINT `article_category_translation_id_article_category_id` FOREIGN KEY (`id`) REFERENCES `article_category`(`id`) ON UPDATE CASCADE ON DELETE CASCADE;
ALTER TABLE `class_has_user` ADD CONSTRAINT `class_has_user_user_id_sf_guard_user_id` FOREIGN KEY (`user_id`) REFERENCES `sf_guard_user`(`id`) ON UPDATE CASCADE ON DELETE CASCADE;
ALTER TABLE `class_has_user` ADD CONSTRAINT `class_has_user_class_id_teacher_class_id` FOREIGN KEY (`class_id`) REFERENCES `teacher_class`(`id`) ON UPDATE CASCADE ON DELETE CASCADE;
ALTER TABLE `friend` ADD CONSTRAINT `friend_user_id_sf_guard_user_id` FOREIGN KEY (`user_id`) REFERENCES `sf_guard_user`(`id`) ON UPDATE CASCADE ON DELETE CASCADE;
ALTER TABLE `friend` ADD CONSTRAINT `friend_friend_id_sf_guard_user_id` FOREIGN KEY (`friend_id`) REFERENCES `sf_guard_user`(`id`) ON UPDATE CASCADE ON DELETE CASCADE;
ALTER TABLE `friend` ADD CONSTRAINT `friend_friend_id_friend_id` FOREIGN KEY (`friend_id`) REFERENCES `friend`(`id`);
ALTER TABLE `game` ADD CONSTRAINT `game_teacher_id_sf_guard_user_id` FOREIGN KEY (`teacher_id`) REFERENCES `sf_guard_user`(`id`) ON UPDATE CASCADE ON DELETE CASCADE;
ALTER TABLE `game_teacher_permission` ADD CONSTRAINT `gssi` FOREIGN KEY (`sf_guard_user_permission_id`) REFERENCES `sf_guard_permission`(`id`);
ALTER TABLE `game_teacher_permission` ADD CONSTRAINT `game_teacher_permission_teacher_id_sf_guard_user_id` FOREIGN KEY (`teacher_id`) REFERENCES `sf_guard_user`(`id`);
ALTER TABLE `game_teacher_permission` ADD CONSTRAINT `game_teacher_permission_game_id_game_id` FOREIGN KEY (`game_id`) REFERENCES `game`(`id`);
ALTER TABLE `internal_category` ADD CONSTRAINT `internal_category_user_id_sf_guard_user_id` FOREIGN KEY (`user_id`) REFERENCES `sf_guard_user`(`id`) ON UPDATE CASCADE ON DELETE CASCADE;
ALTER TABLE `internal_message` ADD CONSTRAINT `internal_message_receiver_id_sf_guard_user_id` FOREIGN KEY (`receiver_id`) REFERENCES `sf_guard_user`(`id`) ON UPDATE SET NULL ON DELETE SET NULL;
ALTER TABLE `internal_message` ADD CONSTRAINT `internal_message_author_id_sf_guard_user_id` FOREIGN KEY (`author_id`) REFERENCES `sf_guard_user`(`id`) ON UPDATE SET NULL ON DELETE SET NULL;
ALTER TABLE `internal_message` ADD CONSTRAINT `iiii_3` FOREIGN KEY (`internal_conversation_id`) REFERENCES `internal_conversation`(`id`) ON UPDATE CASCADE ON DELETE CASCADE;
ALTER TABLE `internal_message_category` ADD CONSTRAINT `internal_message_category_user_id_sf_guard_user_id` FOREIGN KEY (`user_id`) REFERENCES `sf_guard_user`(`id`) ON UPDATE CASCADE ON DELETE CASCADE;
ALTER TABLE `internal_message_category` ADD CONSTRAINT `iiii_7` FOREIGN KEY (`internal_category_id`) REFERENCES `internal_category`(`id`) ON UPDATE CASCADE ON DELETE CASCADE;
ALTER TABLE `internal_message_category` ADD CONSTRAINT `iiii_6` FOREIGN KEY (`internal_message_id`) REFERENCES `internal_message`(`id`) ON UPDATE CASCADE ON DELETE CASCADE;
ALTER TABLE `invitation` ADD CONSTRAINT `invitation_inviter_id_sf_guard_user_id` FOREIGN KEY (`inviter_id`) REFERENCES `sf_guard_user`(`id`) ON UPDATE CASCADE ON DELETE CASCADE;
ALTER TABLE `layout` ADD CONSTRAINT `layout_module_id_layout_module_id` FOREIGN KEY (`module_id`) REFERENCES `layout_module`(`id`) ON UPDATE CASCADE ON DELETE CASCADE;
ALTER TABLE `layout_layout_param` ADD CONSTRAINT `layout_layout_param_param_id_layout_param_id` FOREIGN KEY (`param_id`) REFERENCES `layout_param`(`id`) ON UPDATE CASCADE ON DELETE CASCADE;
ALTER TABLE `layout_layout_param` ADD CONSTRAINT `layout_layout_param_layout_id_layout_id` FOREIGN KEY (`layout_id`) REFERENCES `layout`(`id`) ON UPDATE CASCADE ON DELETE CASCADE;
ALTER TABLE `log_decision` ADD CONSTRAINT `log_decision_user_id_sf_guard_user_id` FOREIGN KEY (`user_id`) REFERENCES `sf_guard_user`(`id`) ON UPDATE CASCADE ON DELETE CASCADE;
ALTER TABLE `log_decision` ADD CONSTRAINT `log_decision_round_id_round_id` FOREIGN KEY (`round_id`) REFERENCES `round`(`id`) ON UPDATE CASCADE ON DELETE CASCADE;
ALTER TABLE `log_event` ADD CONSTRAINT `log_event_user_id_sf_guard_user_id` FOREIGN KEY (`user_id`) REFERENCES `sf_guard_user`(`id`) ON UPDATE CASCADE ON DELETE CASCADE;
ALTER TABLE `log_event` ADD CONSTRAINT `log_event_team_id_team_id` FOREIGN KEY (`team_id`) REFERENCES `team`(`id`) ON UPDATE CASCADE ON DELETE CASCADE;
ALTER TABLE `log_event` ADD CONSTRAINT `log_event_round_id_round_id` FOREIGN KEY (`round_id`) REFERENCES `round`(`id`) ON UPDATE CASCADE ON DELETE CASCADE;
ALTER TABLE `log_message_displayed` ADD CONSTRAINT `log_message_displayed_message_id_message_id` FOREIGN KEY (`message_id`) REFERENCES `message`(`id`) ON UPDATE CASCADE ON DELETE CASCADE;
ALTER TABLE `message` ADD CONSTRAINT `message_user_id_sf_guard_user_id` FOREIGN KEY (`user_id`) REFERENCES `sf_guard_user`(`id`) ON UPDATE CASCADE ON DELETE CASCADE;
ALTER TABLE `message` ADD CONSTRAINT `message_team_id_team_id` FOREIGN KEY (`team_id`) REFERENCES `team`(`id`) ON UPDATE CASCADE ON DELETE CASCADE;
ALTER TABLE `message` ADD CONSTRAINT `message_round_id_round_id` FOREIGN KEY (`round_id`) REFERENCES `round`(`id`) ON UPDATE CASCADE ON DELETE CASCADE;
ALTER TABLE `message_center` ADD CONSTRAINT `message_center_message_channel_id_message_channel_id` FOREIGN KEY (`message_channel_id`) REFERENCES `message_channel`(`id`) ON UPDATE CASCADE ON DELETE CASCADE;
ALTER TABLE `message_center` ADD CONSTRAINT `message_center_layout_id_layout_id` FOREIGN KEY (`layout_id`) REFERENCES `layout`(`id`) ON UPDATE CASCADE ON DELETE CASCADE;
ALTER TABLE `message_center_file` ADD CONSTRAINT `message_center_file_message_center_id_message_center_id` FOREIGN KEY (`message_center_id`) REFERENCES `message_center`(`id`) ON UPDATE CASCADE ON DELETE CASCADE;
ALTER TABLE `message_center_file_translation` ADD CONSTRAINT `message_center_file_translation_id_message_center_file_id` FOREIGN KEY (`id`) REFERENCES `message_center_file`(`id`) ON UPDATE CASCADE ON DELETE CASCADE;
ALTER TABLE `message_multisend_history` ADD CONSTRAINT `mmmi` FOREIGN KEY (`message_multisend_type_id`) REFERENCES `message_multisend_type`(`id`) ON UPDATE CASCADE ON DELETE CASCADE;
ALTER TABLE `message_multisend_history` ADD CONSTRAINT `message_multisend_history_user_id_sf_guard_user_id` FOREIGN KEY (`user_id`) REFERENCES `sf_guard_user`(`id`) ON UPDATE CASCADE ON DELETE CASCADE;
ALTER TABLE `message_multisend_history` ADD CONSTRAINT `message_multisend_history_newsletter_user_id_newsletter_user_id` FOREIGN KEY (`newsletter_user_id`) REFERENCES `newsletter_user`(`id`) ON UPDATE CASCADE ON DELETE CASCADE;
ALTER TABLE `message_multisend_history` ADD CONSTRAINT `message_multisend_history_message_center_id_message_center_id` FOREIGN KEY (`message_center_id`) REFERENCES `message_center`(`id`) ON UPDATE CASCADE ON DELETE CASCADE;
ALTER TABLE `message_multisend_list` ADD CONSTRAINT `mmmi_1` FOREIGN KEY (`message_multisend_type_id`) REFERENCES `message_multisend_type`(`id`) ON UPDATE CASCADE ON DELETE CASCADE;
ALTER TABLE `message_multisend_list` ADD CONSTRAINT `message_multisend_list_user_id_sf_guard_user_id` FOREIGN KEY (`user_id`) REFERENCES `sf_guard_user`(`id`) ON UPDATE CASCADE ON DELETE CASCADE;
ALTER TABLE `message_multisend_list` ADD CONSTRAINT `message_multisend_list_newsletter_user_id_newsletter_user_id` FOREIGN KEY (`newsletter_user_id`) REFERENCES `newsletter_user`(`id`) ON UPDATE CASCADE ON DELETE CASCADE;
ALTER TABLE `message_multisend_list` ADD CONSTRAINT `message_multisend_list_message_center_id_message_center_id` FOREIGN KEY (`message_center_id`) REFERENCES `message_center`(`id`) ON UPDATE CASCADE ON DELETE CASCADE;
ALTER TABLE `message_template` ADD CONSTRAINT `message_template_message_center_id_message_center_id` FOREIGN KEY (`message_center_id`) REFERENCES `message_center`(`id`) ON UPDATE CASCADE ON DELETE CASCADE;
ALTER TABLE `message_template_translation` ADD CONSTRAINT `message_template_translation_id_message_template_id` FOREIGN KEY (`id`) REFERENCES `message_template`(`id`) ON UPDATE CASCADE ON DELETE CASCADE;
ALTER TABLE `newsletter_user` ADD CONSTRAINT `newsletter_user_user_id_sf_guard_user_id` FOREIGN KEY (`user_id`) REFERENCES `sf_guard_user`(`id`) ON UPDATE CASCADE ON DELETE CASCADE;
ALTER TABLE `layout_param` ADD CONSTRAINT `layout_param_module_id_layout_module_id` FOREIGN KEY (`module_id`) REFERENCES `layout_module`(`id`) ON UPDATE CASCADE ON DELETE CASCADE;
ALTER TABLE `article_preferred_article` ADD CONSTRAINT `article_preferred_article_preferred_id_article_id` FOREIGN KEY (`preferred_id`) REFERENCES `article`(`id`) ON UPDATE CASCADE ON DELETE CASCADE;
ALTER TABLE `round` ADD CONSTRAINT `round_team_id_team_id` FOREIGN KEY (`team_id`) REFERENCES `team`(`id`) ON UPDATE CASCADE ON DELETE CASCADE;
ALTER TABLE `article_tag_translation` ADD CONSTRAINT `article_tag_translation_id_article_tag_id` FOREIGN KEY (`id`) REFERENCES `article_tag`(`id`) ON UPDATE CASCADE ON DELETE CASCADE;
ALTER TABLE `teacher_class` ADD CONSTRAINT `teacher_class_teacher_id_sf_guard_user_id` FOREIGN KEY (`teacher_id`) REFERENCES `sf_guard_user`(`id`) ON UPDATE CASCADE ON DELETE CASCADE;
ALTER TABLE `team` ADD CONSTRAINT `team_game_id_game_id` FOREIGN KEY (`game_id`) REFERENCES `game`(`id`) ON UPDATE CASCADE ON DELETE CASCADE;
ALTER TABLE `user_message_settings` ADD CONSTRAINT `user_message_settings_user_id_sf_guard_user_id` FOREIGN KEY (`user_id`) REFERENCES `sf_guard_user`(`id`) ON UPDATE CASCADE ON DELETE CASCADE;
ALTER TABLE `user_message_settings` ADD CONSTRAINT `user_message_settings_message_center_id_message_center_id` FOREIGN KEY (`message_center_id`) REFERENCES `message_center`(`id`) ON UPDATE CASCADE ON DELETE CASCADE;
ALTER TABLE `user_has_team` ADD CONSTRAINT `user_has_team_user_id_sf_guard_user_id` FOREIGN KEY (`user_id`) REFERENCES `sf_guard_user`(`id`) ON UPDATE CASCADE ON DELETE CASCADE;
ALTER TABLE `user_has_team` ADD CONSTRAINT `user_has_team_team_id_team_id` FOREIGN KEY (`team_id`) REFERENCES `team`(`id`) ON UPDATE CASCADE ON DELETE CASCADE;
ALTER TABLE `i18n_translations` ADD CONSTRAINT `i18n_translations_cat_id_i18n_category_cat_id` FOREIGN KEY (`cat_id`) REFERENCES `i18n_category`(`cat_id`) ON DELETE CASCADE;
ALTER TABLE `sf_guard_forgot_password` ADD CONSTRAINT `sf_guard_forgot_password_user_id_sf_guard_user_id` FOREIGN KEY (`user_id`) REFERENCES `sf_guard_user`(`id`) ON DELETE CASCADE;
ALTER TABLE `sf_guard_group_permission` ADD CONSTRAINT `sf_guard_group_permission_permission_id_sf_guard_permission_id` FOREIGN KEY (`permission_id`) REFERENCES `sf_guard_permission`(`id`) ON DELETE CASCADE;
ALTER TABLE `sf_guard_group_permission` ADD CONSTRAINT `sf_guard_group_permission_group_id_sf_guard_group_id` FOREIGN KEY (`group_id`) REFERENCES `sf_guard_group`(`id`) ON DELETE CASCADE;
ALTER TABLE `sf_guard_remember_key` ADD CONSTRAINT `sf_guard_remember_key_user_id_sf_guard_user_id` FOREIGN KEY (`user_id`) REFERENCES `sf_guard_user`(`id`) ON DELETE CASCADE;
ALTER TABLE `sf_guard_user_index` ADD CONSTRAINT `sf_guard_user_index_id_sf_guard_user_id` FOREIGN KEY (`id`) REFERENCES `sf_guard_user`(`id`) ON UPDATE CASCADE ON DELETE CASCADE;
ALTER TABLE `sf_guard_user_group` ADD CONSTRAINT `sf_guard_user_group_user_id_sf_guard_user_id` FOREIGN KEY (`user_id`) REFERENCES `sf_guard_user`(`id`) ON DELETE CASCADE;
ALTER TABLE `sf_guard_user_group` ADD CONSTRAINT `sf_guard_user_group_group_id_sf_guard_group_id` FOREIGN KEY (`group_id`) REFERENCES `sf_guard_group`(`id`) ON DELETE CASCADE;
ALTER TABLE `sf_guard_user_permission` ADD CONSTRAINT `sf_guard_user_permission_user_id_sf_guard_user_id` FOREIGN KEY (`user_id`) REFERENCES `sf_guard_user`(`id`) ON DELETE CASCADE;
ALTER TABLE `sf_guard_user_permission` ADD CONSTRAINT `sf_guard_user_permission_permission_id_sf_guard_permission_id` FOREIGN KEY (`permission_id`) REFERENCES `sf_guard_permission`(`id`) ON DELETE CASCADE;
