<?php

class artGuardUser extends artGuardSecurityUser {

  /**
   * Funkcja sprawdza czy uzytkownik bedzie widzial podany w parametrze link.
   * Linki dostepne w FM to:
   * 'article_add', 'article_edit', 'article_meta_edit', 'article_gallery', 'article_delete',
   * 'category_add', 'category_edit', 'category_delete'
   * 'reference_add', 'reference_edit', 'reference_delete'
   * Oraz z pluginu tlumaczen:
   * 'translation_edit'
   *
   * @param string $link
   * @return string
   */
  public function hasFmLink($link) {
    return (sfConfig::get('app_fm_enabled', false) && sfConfig::get('app_fm_' . $link, false));
  }

  /**
   * Funkcja sprawdza czy funkcja hasFmLink() zwroci co najmniej jeden TRUE
   * dla podanej tablicy linkow
   *
   * @param array $links
   * @return boolean
   */
  public function hasAnyFmLink($links) {
    foreach ($links as $link) {
      if ($this->hasFmLink($link)) {
        return true;
      }
    }

    return false;
  }

  public function isTeacher() {
    return $this->hasCredential('teacher') || $this->isAdmin();
  }

  public function isTeacherDemo() {
    return $this->hasCredential('teacher_demo');
  }

  public function isTester() {
    return $this->hasCredential('tester');
  }

  /**
   * Metoda ustawia team_id w sesji;
   */
  public function setActiveTeamId($teamId) {

    if ($this->setAttribute('team_id', $teamId)) {
      return true;
    } else {
      return false;
    };
  }

  /**
   * Metoda pobiera team_id w sesji;
   *
   * @return: string;
   */
  public function getActiveTeamId() {
    return $this->getAttribute('team_id', false);
  }

  /**
   * Metoda zwraca obiekt z zespołem, do którego aktualnie przypisany jest użytkowik, wybranego po zalogowaniu.
   *
   * @return: object; false on error;
   */
  public function getActiveTeam() {

    $team = Doctrine::getTable('Team')->findOneById($this->getActiveTeamId());

    if ($team) {
      return $team;
    } else {
      return false;
    }
  }

  /**
   * Zwraca dane z tabeli log_decision podjete przez zespol 
   * 
   * @return type
   */
  public function getLogDecisionActiveTeamData() {

    $team = $this->getActiveTeamId();
    return Doctrine::getTable('Round')
                    ->createQuery('r')
                    ->leftJoin('r.Team t')
                    ->leftJoin('r.log_decisions ld')
                    ->leftJoin('ld.User u')
                    ->where('t.id = ?', $team)
                    ->orderBy('r.round_number DESC')
                    ->addOrderBy('ld.created_at DESC')
                    ->execute();
  }

}
