<?php

/**
 * LogEvent filter form.
 *
 * @package    hotel
 * @subpackage filter
 * @author     Your name here
 * @version    SVN: $Id: sfDoctrineFormFilterTemplate.php 23810 2009-11-12 11:07:44Z Kris.Wallsmith $
 */
class LogEventFormFilter extends BaseLogEventFormFilter {

  public function setup() {
    $this->setWidgets(array(
        'team_id' => new sfWidgetFormDoctrineChoice(
                array(
            'model' => $this->getRelatedModelName('Team')
            , 'add_empty' => true
            , 'table_method' => 'getTeacherTeams')
        ),
        'event' => new sfWidgetFormFilterInput(),
        'text' => new sfWidgetFormFilterInput(),
        'value' => new sfWidgetFormFilterInput(),
        'created_at' =>
        new sfWidgetFormFilterDate(array('from_date' => new sfWidgetFormDate(), 'to_date' => new sfWidgetFormDate(), 'with_empty' => false)),
    ));

    $this->setValidators(array(
        'team_id' => new sfValidatorDoctrineChoice(array('required' => false, 'model' => $this->getRelatedModelName('Team'), 'column' => 'id')),
        'event' => new sfValidatorPass(array('required' => false)),
        'text' => new sfValidatorPass(array('required' => false)),
        'value' => new sfValidatorPass(array('required' => false)),
        'created_at' => new sfValidatorDateRange(array('required' => false
            , 'from_date' => new sfValidatorDateTime(array('required' => false, 'datetime_output' => 'Y-m-d 00:00:00'))
            , 'to_date' => new sfValidatorDateTime(array('required' => false, 'datetime_output' => 'Y-m-d 23:59:59')))),
    ));

    $this->widgetSchema->setNameFormat('log_event_filters[%s]');

    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);

    $this->setupInheritance();
  }

  protected function addRoundIdColumnQuery(Doctrine_Query $query, $field, $values) {
    $rootAlias = $query->getRootAlias();
//   $query->leftJoin("$rootAlias.LogEvent rrt"); 
    $query->andWhere("$rootAlias.round_id = ?", $values);
  }

}

