<?php

abstract class BaseArticleCommentFormFilter extends BaseFormFilterDoctrine
{
  public function setup()
  {
    $this->setWidgets(array(
      'article_id' => new sfArtWidgetFormDoctrineJQueryMultiSelect(array('multiple' => true, 'model' => $this->getRelatedModelName('Article'))),
      'user_id' => new sfArtWidgetFormDoctrineJQueryMultiSelect(array('multiple' => true, 'model' => $this->getRelatedModelName('sfGuardUser'))),
      'parent_article_comment_id' => new sfArtWidgetFormDoctrineJQueryMultiSelect(array('multiple' => true, 'model' => $this->getRelatedModelName('ArticleComment'))),
      'text' => new sfArtWidgetFormFilterInput(array('with_empty' => false)),
      'display' => new sfArtWidgetFormFilterBoolRadio(),
      'nick' => new sfArtWidgetFormFilterInput(),
      'email' => new sfArtWidgetFormFilterInput(),
      'www' => new sfArtWidgetFormFilterInput(),
      'gg' => new sfArtWidgetFormFilterInput(),
      'notify' => new sfArtWidgetFormFilterBoolRadio(),
      'created_at' => new sfArtWidgetFormInputJQueryDateTimeRange(array('culture' => sfContext::getInstance()->getUser()->getCulture() )),
      'updated_at' => new sfArtWidgetFormInputJQueryDateTimeRange(array('culture' => sfContext::getInstance()->getUser()->getCulture() )),
    ));

    $this->setValidators(array(
      'article_id' => new sfValidatorDoctrineChoice(array('required' => false, 'model' => $this->getRelatedModelName('Article'), 'column' => 'id', 'multiple'=>true)),
      'user_id' => new sfValidatorDoctrineChoice(array('required' => false, 'model' => $this->getRelatedModelName('sfGuardUser'), 'column' => 'id', 'multiple'=>true)),
      'parent_article_comment_id' => new sfValidatorDoctrineChoice(array('required' => false, 'model' => $this->getRelatedModelName('ArticleComment'), 'column' => 'id', 'multiple'=>true)),
      'text' => new sfValidatorPass(array('required' => false)),
      'display' => new sfValidatorChoice(array('required' => false, 'choices' => array('', 1, 0))),
      'nick' => new sfValidatorPass(array('required' => false)),
      'email' => new sfValidatorPass(array('required' => false)),
      'www' => new sfValidatorPass(array('required' => false)),
      'gg' => new sfValidatorPass(array('required' => false)),
      'notify' => new sfValidatorChoice(array('required' => false, 'choices' => array('', 1, 0))),
      'created_at' => new sfValidatorDateRange(array('required' => false, 'from_date' => new sfValidatorDateTime(array('required' => false)), 'to_date' => new sfValidatorDateTime(array('required' => false)))),
      'updated_at' => new sfValidatorDateRange(array('required' => false, 'from_date' => new sfValidatorDateTime(array('required' => false)), 'to_date' => new sfValidatorDateTime(array('required' => false)))),
    ));

    $this->widgetSchema->setNameFormat('article_comment_filters[%s]');
    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);
    $this->setupInheritance();
  }

  public function getModelName()
  {
    return 'ArticleComment';
  }

  public function getFields()
  {
    return array(
      'id'                        => 'Number',
      'article_id'                => 'ForeignKey',
      'user_id'                   => 'ForeignKey',
      'parent_article_comment_id' => 'ForeignKey',
      'text'                      => 'Text',
      'display'                   => 'Boolean',
      'nick'                      => 'Text',
      'email'                     => 'Text',
      'www'                       => 'Text',
      'gg'                        => 'Text',
      'notify'                    => 'Boolean',
      'created_at'                => 'Date',
      'updated_at'                => 'Date',
    );
  }
}
