<?php

abstract class BaseArticleFormFilter extends BaseFormFilterDoctrine
{
  public function setup()
  {
    $this->setWidgets(array(
      'creator_id' => new sfArtWidgetFormDoctrineJQueryMultiSelect(array('multiple' => true, 'model' => $this->getRelatedModelName('sfGuardUser'))),
      'editor_id' => new sfArtWidgetFormDoctrineJQueryMultiSelect(array('multiple' => true, 'model' => $this->getRelatedModelName('sfGuardUserEditor'))),
      'layout_id' => new sfArtWidgetFormDoctrineJQueryMultiSelect(array('multiple' => true, 'model' => $this->getRelatedModelName('Layout'))),
      'unique_name' => new sfArtWidgetFormFilterInput(),
      'is_displayed' => new sfArtWidgetFormFilterInput(),
      'start_at' => new sfArtWidgetFormInputJQueryDateTimeRange(array('culture' => sfContext::getInstance()->getUser()->getCulture() )),
      'expire_at' => new sfArtWidgetFormInputJQueryDateTimeRange(array('culture' => sfContext::getInstance()->getUser()->getCulture() )),
      'flag' => new sfArtWidgetFormFilterInput(),
      'title_image' => new sfArtWidgetFormFilterInput(),
      'title_image_label' => new sfArtWidgetFormFilterInput(),
      'big_image' => new sfArtWidgetFormFilterInput(),
      'views' => new sfArtWidgetFormFilterInput(),
      'vote_sum' => new sfArtWidgetFormFilterInput(),
      'vote_count' => new sfArtWidgetFormFilterInput(),
      'source' => new sfArtWidgetFormFilterInput(),
      'created_at' => new sfArtWidgetFormInputJQueryDateTimeRange(array('culture' => sfContext::getInstance()->getUser()->getCulture() )),
      'updated_at' => new sfArtWidgetFormInputJQueryDateTimeRange(array('culture' => sfContext::getInstance()->getUser()->getCulture() )),
      'categories_list' => new sfArtWidgetFormDoctrineJQueryMultiselect(array('multiple' => true, 'model' => 'Category')),
      'tags_list' => new sfArtWidgetFormDoctrineJQueryMultiselect(array('multiple' => true, 'model' => 'Tag')),
      'permissions_list' => new sfArtWidgetFormDoctrineJQueryMultiselect(array('multiple' => true, 'model' => 'sfGuardPermission')),
      'groups_list' => new sfArtWidgetFormDoctrineJQueryMultiselect(array('multiple' => true, 'model' => 'sfGuardGroup')),
      'article_blog_categories_list' => new sfArtWidgetFormDoctrineJQueryMultiselect(array('multiple' => true, 'model' => 'ArticleBlogCategory')),
    ));

    $this->setValidators(array(
      'creator_id' => new sfValidatorDoctrineChoice(array('required' => false, 'model' => $this->getRelatedModelName('sfGuardUser'), 'column' => 'id', 'multiple'=>true)),
      'editor_id' => new sfValidatorDoctrineChoice(array('required' => false, 'model' => $this->getRelatedModelName('sfGuardUserEditor'), 'column' => 'id', 'multiple'=>true)),
      'layout_id' => new sfValidatorDoctrineChoice(array('required' => false, 'model' => $this->getRelatedModelName('Layout'), 'column' => 'id', 'multiple'=>true)),
      'unique_name' => new sfValidatorPass(array('required' => false)),
      'is_displayed' => new sfValidatorSchemaFilter('text', new sfValidatorInteger(array('required' => false))),
      'start_at' => new sfValidatorDateRange(array('required' => false, 'from_date' => new sfValidatorDateTime(array('required' => false)), 'to_date' => new sfValidatorDateTime(array('required' => false)))),
      'expire_at' => new sfValidatorDateRange(array('required' => false, 'from_date' => new sfValidatorDateTime(array('required' => false)), 'to_date' => new sfValidatorDateTime(array('required' => false)))),
      'flag' => new sfValidatorPass(array('required' => false)),
      'title_image' => new sfValidatorPass(array('required' => false)),
      'title_image_label' => new sfValidatorPass(array('required' => false)),
      'big_image' => new sfValidatorPass(array('required' => false)),
      'views' => new sfValidatorSchemaFilter('text', new sfValidatorInteger(array('required' => false))),
      'vote_sum' => new sfValidatorSchemaFilter('text', new sfValidatorNumber(array('required' => false))),
      'vote_count' => new sfValidatorSchemaFilter('text', new sfValidatorInteger(array('required' => false))),
      'source' => new sfValidatorPass(array('required' => false)),
      'created_at' => new sfValidatorDateRange(array('required' => false, 'from_date' => new sfValidatorDateTime(array('required' => false)), 'to_date' => new sfValidatorDateTime(array('required' => false)))),
      'updated_at' => new sfValidatorDateRange(array('required' => false, 'from_date' => new sfValidatorDateTime(array('required' => false)), 'to_date' => new sfValidatorDateTime(array('required' => false)))),
      'categories_list' => new sfValidatorDoctrineChoice(array('multiple' => true, 'model' => 'Category', 'required' => false)),
      'tags_list' => new sfValidatorDoctrineChoice(array('multiple' => true, 'model' => 'Tag', 'required' => false)),
      'permissions_list' => new sfValidatorDoctrineChoice(array('multiple' => true, 'model' => 'sfGuardPermission', 'required' => false)),
      'groups_list' => new sfValidatorDoctrineChoice(array('multiple' => true, 'model' => 'sfGuardGroup', 'required' => false)),
      'article_blog_categories_list' => new sfValidatorDoctrineChoice(array('multiple' => true, 'model' => 'ArticleBlogCategory', 'required' => false)),
    ));

    $this->widgetSchema->setNameFormat('article_filters[%s]');
    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);
    $this->setupInheritance();
  }

  public function addCategoriesListColumnQuery(Doctrine_Query $query, $field, $values)
  {
    if (!is_array($values))
      $values = array($values);

    if (!count($values))
      return;

    $query
      ->leftJoin($query->getRootAlias().'.ArticleCategory ArticleCategory')
      ->andWhereIn('ArticleCategory.category_id', $values);
  }

  public function addTagsListColumnQuery(Doctrine_Query $query, $field, $values)
  {
    if (!is_array($values))
      $values = array($values);

    if (!count($values))
      return;

    $query
      ->leftJoin($query->getRootAlias().'.ArticleTag ArticleTag')
      ->andWhereIn('ArticleTag.tag_id', $values);
  }

  public function addPermissionsListColumnQuery(Doctrine_Query $query, $field, $values)
  {
    if (!is_array($values))
      $values = array($values);

    if (!count($values))
      return;

    $query
      ->leftJoin($query->getRootAlias().'.ArticlePermission ArticlePermission')
      ->andWhereIn('ArticlePermission.permission_id', $values);
  }

  public function addGroupsListColumnQuery(Doctrine_Query $query, $field, $values)
  {
    if (!is_array($values))
      $values = array($values);

    if (!count($values))
      return;

    $query
      ->leftJoin($query->getRootAlias().'.ArticleGroup ArticleGroup')
      ->andWhereIn('ArticleGroup.group_id', $values);
  }

  public function addArticleBlogCategoriesListColumnQuery(Doctrine_Query $query, $field, $values)
  {
    if (!is_array($values))
      $values = array($values);

    if (!count($values))
      return;

    $query
      ->leftJoin($query->getRootAlias().'.ArticleArticleBlogCategory ArticleArticleBlogCategory')
      ->andWhereIn('ArticleArticleBlogCategory.article_blog_category_id', $values);
  }

  public function getModelName()
  {
    return 'Article';
  }

  public function getFields()
  {
    return array(
      'id'                           => 'Number',
      'creator_id'                   => 'ForeignKey',
      'editor_id'                    => 'ForeignKey',
      'layout_id'                    => 'ForeignKey',
      'unique_name'                  => 'Text',
      'is_displayed'                 => 'Number',
      'start_at'                     => 'Date',
      'expire_at'                    => 'Date',
      'flag'                         => 'Text',
      'title_image'                  => 'Text',
      'title_image_label'            => 'Text',
      'big_image'                    => 'Text',
      'views'                        => 'Number',
      'vote_sum'                     => 'Number',
      'vote_count'                   => 'Number',
      'source'                       => 'Text',
      'created_at'                   => 'Date',
      'updated_at'                   => 'Date',
      'categories_list'              => 'ManyKey',
      'tags_list'                    => 'ManyKey',
      'permissions_list'             => 'ManyKey',
      'groups_list'                  => 'ManyKey',
      'article_blog_categories_list' => 'ManyKey',
    );
  }
}
