<?php

abstract class BaseArticlePhotoFormFilter extends BaseFormFilterDoctrine
{
  public function setup()
  {
    $this->setWidgets(array(
      'article_id' => new sfArtWidgetFormDoctrineJQueryMultiSelect(array('multiple' => true, 'model' => $this->getRelatedModelName('Article'))),
      'original_image' => new sfArtWidgetFormFilterInput(),
      'small_image' => new sfArtWidgetFormFilterInput(),
      'medium_image' => new sfArtWidgetFormFilterInput(),
      'big_image' => new sfArtWidgetFormFilterInput(),
      'order' => new sfArtWidgetFormFilterInput(),
      'created_at' => new sfArtWidgetFormInputJQueryDateTimeRange(array('culture' => sfContext::getInstance()->getUser()->getCulture() )),
      'updated_at' => new sfArtWidgetFormInputJQueryDateTimeRange(array('culture' => sfContext::getInstance()->getUser()->getCulture() )),
    ));

    $this->setValidators(array(
      'article_id' => new sfValidatorDoctrineChoice(array('required' => false, 'model' => $this->getRelatedModelName('Article'), 'column' => 'id', 'multiple'=>true)),
      'original_image' => new sfValidatorPass(array('required' => false)),
      'small_image' => new sfValidatorPass(array('required' => false)),
      'medium_image' => new sfValidatorPass(array('required' => false)),
      'big_image' => new sfValidatorPass(array('required' => false)),
      'order' => new sfValidatorSchemaFilter('text', new sfValidatorInteger(array('required' => false))),
      'created_at' => new sfValidatorDateRange(array('required' => false, 'from_date' => new sfValidatorDateTime(array('required' => false)), 'to_date' => new sfValidatorDateTime(array('required' => false)))),
      'updated_at' => new sfValidatorDateRange(array('required' => false, 'from_date' => new sfValidatorDateTime(array('required' => false)), 'to_date' => new sfValidatorDateTime(array('required' => false)))),
    ));

    $this->widgetSchema->setNameFormat('article_photo_filters[%s]');
    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);
    $this->setupInheritance();
  }

  public function getModelName()
  {
    return 'ArticlePhoto';
  }

  public function getFields()
  {
    return array(
      'id'             => 'Number',
      'article_id'     => 'ForeignKey',
      'original_image' => 'Text',
      'small_image'    => 'Text',
      'medium_image'   => 'Text',
      'big_image'      => 'Text',
      'order'          => 'Number',
      'created_at'     => 'Date',
      'updated_at'     => 'Date',
    );
  }
}
