<?php
 
abstract class BaseArticleTranslationFormFilter extends BaseFormFilterDoctrine
{
  public function setup()
  {
    $this->setWidgets(array(
      'title' => new sfArtWidgetFormFilterInput(array('with_empty' => false)),
      'description' => new sfArtWidgetFormFilterInput(array('with_empty' => false)),
      'short_description' => new sfArtWidgetFormFilterInput(),
      'meta_title' => new sfArtWidgetFormFilterInput(),
      'meta_description' => new sfArtWidgetFormFilterInput(),
      'meta_keywords' => new sfArtWidgetFormFilterInput(),
      'slug' => new sfArtWidgetFormFilterInput(),
    ));

    $this->setValidators(array(
      'title' => new sfValidatorPass(array('required' => false)),
      'description' => new sfValidatorPass(array('required' => false)),
      'short_description' => new sfValidatorPass(array('required' => false)),
      'meta_title' => new sfValidatorPass(array('required' => false)),
      'meta_description' => new sfValidatorPass(array('required' => false)),
      'meta_keywords' => new sfValidatorPass(array('required' => false)),
      'slug' => new sfValidatorPass(array('required' => false)),
    ));

    $this->widgetSchema->setNameFormat('article_translation_filters[%s]');
    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);
    $this->setupInheritance();
  }

  public function getModelName()
  {
    return 'ArticleTranslation';
  }

  public function getFields()
  {
    return array(
      'id'                => 'Number',
      'title'             => 'Text',
      'description'       => 'Text',
      'short_description' => 'Text',
      'meta_title'        => 'Text',
      'meta_description'  => 'Text',
      'meta_keywords'     => 'Text',
      'lang'              => 'Text',
      'slug'              => 'Text',
    );
  }
}
