<?php

abstract class BaseCategoryFormFilter extends BaseFormFilterDoctrine
{
  public function setup()
  {
    $this->setWidgets(array(
      'title_image' => new sfArtWidgetFormFilterInput(),
      'unique_name' => new sfArtWidgetFormFilterInput(),
      'image_count' => new sfArtWidgetFormFilterInput(),
      'layout_id' => new sfArtWidgetFormDoctrineJQueryMultiSelect(array('multiple' => true, 'model' => $this->getRelatedModelName('Layout'))),
      'is_displayed' => new sfArtWidgetFormFilterInput(),
      'subcategories_list' => new sfArtWidgetFormDoctrineJQueryMultiselect(array('multiple' => true, 'model' => 'Category')),
      'articles_list' => new sfArtWidgetFormDoctrineJQueryMultiselect(array('multiple' => true, 'model' => 'Article')),
      'category_list' => new sfArtWidgetFormDoctrineJQueryMultiselect(array('multiple' => true, 'model' => 'Category')),
    ));

    $this->setValidators(array(
      'title_image' => new sfValidatorPass(array('required' => false)),
      'unique_name' => new sfValidatorPass(array('required' => false)),
      'image_count' => new sfValidatorSchemaFilter('text', new sfValidatorInteger(array('required' => false))),
      'layout_id' => new sfValidatorDoctrineChoice(array('required' => false, 'model' => $this->getRelatedModelName('Layout'), 'column' => 'id', 'multiple'=>true)),
      'is_displayed' => new sfValidatorSchemaFilter('text', new sfValidatorInteger(array('required' => false))),
      'subcategories_list' => new sfValidatorDoctrineChoice(array('multiple' => true, 'model' => 'Category', 'required' => false)),
      'articles_list' => new sfValidatorDoctrineChoice(array('multiple' => true, 'model' => 'Article', 'required' => false)),
      'category_list' => new sfValidatorDoctrineChoice(array('multiple' => true, 'model' => 'Category', 'required' => false)),
    ));

    $this->widgetSchema->setNameFormat('category_filters[%s]');
    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);
    $this->setupInheritance();
  }

  public function addSubcategoriesListColumnQuery(Doctrine_Query $query, $field, $values)
  {
    if (!is_array($values))
      $values = array($values);

    if (!count($values))
      return;

    $query
      ->leftJoin($query->getRootAlias().'.ArticleCategory ArticleCategory')
      ->andWhereIn('ArticleCategory.subcategory_id', $values);
  }

  public function addArticlesListColumnQuery(Doctrine_Query $query, $field, $values)
  {
    if (!is_array($values))
      $values = array($values);

    if (!count($values))
      return;

    $query
      ->leftJoin($query->getRootAlias().'.ArticleCategory ArticleCategory')
      ->andWhereIn('ArticleCategory.article_id', $values);
  }

  public function addCategoryListColumnQuery(Doctrine_Query $query, $field, $values)
  {
    if (!is_array($values))
      $values = array($values);

    if (!count($values))
      return;

    $query
      ->leftJoin($query->getRootAlias().'.ArticleCategory ArticleCategory')
      ->andWhereIn('ArticleCategory.category_id', $values);
  }

  public function getModelName()
  {
    return 'Category';
  }

  public function getFields()
  {
    return array(
      'id'                 => 'Number',
      'title_image'        => 'Text',
      'unique_name'        => 'Text',
      'image_count'        => 'Number',
      'layout_id'          => 'ForeignKey',
      'is_displayed'       => 'Number',
      'subcategories_list' => 'ManyKey',
      'articles_list'      => 'ManyKey',
      'category_list'      => 'ManyKey',
    );
  }
}
