<?php

abstract class Basei18nTranslationsFormFilter extends BaseFormFilterDoctrine
{
  public function setup()
  {
    $this->setWidgets(array(
      'cat_id' => new sfArtWidgetFormDoctrineJQueryMultiSelect(array('multiple' => true, 'model' => $this->getRelatedModelName('Category'))),
      'source' => new sfArtWidgetFormFilterInput(array('with_empty' => false)),
      'target' => new sfArtWidgetFormFilterInput(array('with_empty' => false)),
      'comments' => new sfArtWidgetFormFilterInput(),
      'created_at' => new sfArtWidgetFormInputJQueryDateTimeRange(array('culture' => sfContext::getInstance()->getUser()->getCulture() )),
      'updated_at' => new sfArtWidgetFormInputJQueryDateTimeRange(array('culture' => sfContext::getInstance()->getUser()->getCulture() )),
      'translated' => new sfArtWidgetFormFilterBoolRadio(),
    ));

    $this->setValidators(array(
      'cat_id' => new sfValidatorDoctrineChoice(array('required' => false, 'model' => $this->getRelatedModelName('Category'), 'column' => 'cat_id', 'multiple'=>true)),
      'source' => new sfValidatorPass(array('required' => false)),
      'target' => new sfValidatorPass(array('required' => false)),
      'comments' => new sfValidatorPass(array('required' => false)),
      'created_at' => new sfValidatorDateRange(array('required' => false, 'from_date' => new sfValidatorDateTime(array('required' => false)), 'to_date' => new sfValidatorDateTime(array('required' => false)))),
      'updated_at' => new sfValidatorDateRange(array('required' => false, 'from_date' => new sfValidatorDateTime(array('required' => false)), 'to_date' => new sfValidatorDateTime(array('required' => false)))),
      'translated' => new sfValidatorChoice(array('required' => false, 'choices' => array('', 1, 0))),
    ));

    $this->widgetSchema->setNameFormat('i18n_translations_filters[%s]');
    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);
    $this->setupInheritance();
  }

  public function getModelName()
  {
    return 'i18nTranslations';
  }

  public function getFields()
  {
    return array(
      'id'         => 'Number',
      'cat_id'     => 'ForeignKey',
      'source'     => 'Text',
      'target'     => 'Text',
      'comments'   => 'Text',
      'created_at' => 'Date',
      'updated_at' => 'Date',
      'translated' => 'Boolean',
    );
  }
}
