<?php

abstract class BaseArtConfigurationFormFilter extends BaseFormFilterDoctrine
{
  public function setup()
  {
    $this->setWidgets(array(
      'name' => new sfArtWidgetFormFilterInput(array('with_empty' => false)),
      'editable' => new sfArtWidgetFormFilterInput(array('with_empty' => false)),
      'widget' => new sfArtWidgetFormFilterInput(),
      'validator' => new sfArtWidgetFormFilterInput(),
      'renderer' => new sfArtWidgetFormFilterInput(),
      'default' => new sfArtWidgetFormFilterInput(),
      'order' => new sfArtWidgetFormFilterInput(),
      'created_at' => new sfArtWidgetFormInputJQueryDateTimeRange(array('culture' => sfContext::getInstance()->getUser()->getCulture() )),
      'updated_at' => new sfArtWidgetFormInputJQueryDateTimeRange(array('culture' => sfContext::getInstance()->getUser()->getCulture() )),
    ));

    $this->setValidators(array(
      'name' => new sfValidatorPass(array('required' => false)),
      'editable' => new sfValidatorSchemaFilter('text', new sfValidatorInteger(array('required' => false))),
      'widget' => new sfValidatorPass(array('required' => false)),
      'validator' => new sfValidatorPass(array('required' => false)),
      'renderer' => new sfValidatorPass(array('required' => false)),
      'default' => new sfValidatorPass(array('required' => false)),
      'order' => new sfValidatorSchemaFilter('text', new sfValidatorInteger(array('required' => false))),
      'created_at' => new sfValidatorDateRange(array('required' => false, 'from_date' => new sfValidatorDateTime(array('required' => false)), 'to_date' => new sfValidatorDateTime(array('required' => false)))),
      'updated_at' => new sfValidatorDateRange(array('required' => false, 'from_date' => new sfValidatorDateTime(array('required' => false)), 'to_date' => new sfValidatorDateTime(array('required' => false)))),
    ));

    $this->widgetSchema->setNameFormat('art_configuration_filters[%s]');
    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);
    $this->setupInheritance();
  }

  public function getModelName()
  {
    return 'ArtConfiguration';
  }

  public function getFields()
  {
    return array(
      'id'         => 'Number',
      'name'       => 'Text',
      'editable'   => 'Number',
      'widget'     => 'Text',
      'validator'  => 'Text',
      'renderer'   => 'Text',
      'default'    => 'Text',
      'order'      => 'Number',
      'created_at' => 'Date',
      'updated_at' => 'Date',
    );
  }
}
