<?php

abstract class BaseLayoutFormFilter extends BaseFormFilterDoctrine
{
  public function setup()
  {
    $this->setWidgets(array(
      'name' => new sfArtWidgetFormFilterInput(),
      'module' => new sfArtWidgetFormFilterInput(),
      'view' => new sfArtWidgetFormFilterInput(),
      'description' => new sfArtWidgetFormFilterInput(),
    ));

    $this->setValidators(array(
      'name' => new sfValidatorPass(array('required' => false)),
      'module' => new sfValidatorPass(array('required' => false)),
      'view' => new sfValidatorPass(array('required' => false)),
      'description' => new sfValidatorPass(array('required' => false)),
    ));

    $this->widgetSchema->setNameFormat('layout_filters[%s]');
    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);
    $this->setupInheritance();
  }

  public function getModelName()
  {
    return 'Layout';
  }

  public function getFields()
  {
    return array(
      'id'          => 'Number',
      'name'        => 'Text',
      'module'      => 'Text',
      'view'        => 'Text',
      'description' => 'Text',
    );
  }
}
