<?php

abstract class BaseLayoutParamFormFilter extends BaseFormFilterDoctrine
{
  public function setup()
  {
    $this->setWidgets(array(
      'layout_id' => new sfArtWidgetFormDoctrineJQueryMultiSelect(array('multiple' => true, 'model' => $this->getRelatedModelName('Layout'))),
      'name' => new sfArtWidgetFormFilterInput(),
      'value' => new sfArtWidgetFormFilterInput(),
    ));

    $this->setValidators(array(
      'layout_id' => new sfValidatorDoctrineChoice(array('required' => false, 'model' => $this->getRelatedModelName('Layout'), 'column' => 'id', 'multiple'=>true)),
      'name' => new sfValidatorPass(array('required' => false)),
      'value' => new sfValidatorPass(array('required' => false)),
    ));

    $this->widgetSchema->setNameFormat('layout_param_filters[%s]');
    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);
    $this->setupInheritance();
  }

  public function getModelName()
  {
    return 'LayoutParam';
  }

  public function getFields()
  {
    return array(
      'id'        => 'Number',
      'layout_id' => 'ForeignKey',
      'name'      => 'Text',
      'value'     => 'Text',
    );
  }
}
