<?php

/**
 * Param filter form base class.
 *
 * @package    hotel
 * @subpackage filter
 * @author     Your name here
 * @version    SVN: $Id: sfDoctrineFormFilterGeneratedTemplate.php 29570 2010-05-21 14:49:47Z Kris.Wallsmith $
 */
abstract class BaseParamFormFilter extends BaseFormFilterDoctrine
{
  public function setup()
  {
    $this->setWidgets(array(
      'module_id'    => new sfWidgetFormDoctrineChoice(array('model' => $this->getRelatedModelName('Module'), 'add_empty' => true)),
      'unique_name'  => new sfWidgetFormFilterInput(),
      'validator'    => new sfWidgetFormFilterInput(),
      'widget'       => new sfWidgetFormFilterInput(),
      'default'      => new sfWidgetFormFilterInput(),
      'editable'     => new sfWidgetFormFilterInput(),
      'layouts_list' => new sfWidgetFormDoctrineChoice(array('multiple' => true, 'model' => 'Layout')),
    ));

    $this->setValidators(array(
      'module_id'    => new sfValidatorDoctrineChoice(array('required' => false, 'model' => $this->getRelatedModelName('Module'), 'column' => 'id')),
      'unique_name'  => new sfValidatorPass(array('required' => false)),
      'validator'    => new sfValidatorPass(array('required' => false)),
      'widget'       => new sfValidatorPass(array('required' => false)),
      'default'      => new sfValidatorPass(array('required' => false)),
      'editable'     => new sfValidatorSchemaFilter('text', new sfValidatorInteger(array('required' => false))),
      'layouts_list' => new sfValidatorDoctrineChoice(array('multiple' => true, 'model' => 'Layout', 'required' => false)),
    ));

    $this->widgetSchema->setNameFormat('param_filters[%s]');

    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);

    $this->setupInheritance();

    parent::setup();
  }

  public function addLayoutsListColumnQuery(Doctrine_Query $query, $field, $values)
  {
    if (!is_array($values))
    {
      $values = array($values);
    }

    if (!count($values))
    {
      return;
    }

    $query
      ->leftJoin($query->getRootAlias().'.LayoutParam LayoutParam')
      ->andWhereIn('LayoutParam.layout_id', $values)
    ;
  }

  public function getModelName()
  {
    return 'Param';
  }

  public function getFields()
  {
    return array(
      'id'           => 'Number',
      'module_id'    => 'ForeignKey',
      'unique_name'  => 'Text',
      'validator'    => 'Text',
      'widget'       => 'Text',
      'default'      => 'Text',
      'editable'     => 'Number',
      'layouts_list' => 'ManyKey',
    );
  }
}
