<?php

abstract class BaseInternalMessageFormFilter extends BaseFormFilterDoctrine
{
  public function setup()
  {
    $this->setWidgets(array(
      'internal_conversation_id' => new sfArtWidgetFormDoctrineJQueryMultiSelect(array('multiple' => true, 'model' => $this->getRelatedModelName('InternalConversation'))),
      'author_id' => new sfArtWidgetFormDoctrineJQueryMultiSelect(array('multiple' => true, 'model' => $this->getRelatedModelName('sfGuardAuthor'))),
      'receiver_id' => new sfArtWidgetFormDoctrineJQueryMultiSelect(array('multiple' => true, 'model' => $this->getRelatedModelName('sfGuardUser'))),
      'is_readed' => new sfArtWidgetFormFilterInput(),
      'title' => new sfArtWidgetFormFilterInput(),
      'description' => new sfArtWidgetFormFilterInput(),
      'created_at' => new sfArtWidgetFormInputJQueryDateTimeRange(array('culture' => sfContext::getInstance()->getUser()->getCulture() )),
      'updated_at' => new sfArtWidgetFormInputJQueryDateTimeRange(array('culture' => sfContext::getInstance()->getUser()->getCulture() )),
      'internal_categories_list' => new sfArtWidgetFormDoctrineJQueryMultiselect(array('multiple' => true, 'model' => 'InternalCategory')),
      'users_list' => new sfArtWidgetFormDoctrineJQueryMultiselect(array('multiple' => true, 'model' => 'sfGuardUser')),
    ));

    $this->setValidators(array(
      'internal_conversation_id' => new sfValidatorDoctrineChoice(array('required' => false, 'model' => $this->getRelatedModelName('InternalConversation'), 'column' => 'id', 'multiple'=>true)),
      'author_id' => new sfValidatorDoctrineChoice(array('required' => false, 'model' => $this->getRelatedModelName('sfGuardAuthor'), 'column' => 'id', 'multiple'=>true)),
      'receiver_id' => new sfValidatorDoctrineChoice(array('required' => false, 'model' => $this->getRelatedModelName('sfGuardUser'), 'column' => 'id', 'multiple'=>true)),
      'is_readed' => new sfValidatorSchemaFilter('text', new sfValidatorInteger(array('required' => false))),
      'title' => new sfValidatorPass(array('required' => false)),
      'description' => new sfValidatorPass(array('required' => false)),
      'created_at' => new sfValidatorDateRange(array('required' => false, 'from_date' => new sfValidatorDateTime(array('required' => false)), 'to_date' => new sfValidatorDateTime(array('required' => false)))),
      'updated_at' => new sfValidatorDateRange(array('required' => false, 'from_date' => new sfValidatorDateTime(array('required' => false)), 'to_date' => new sfValidatorDateTime(array('required' => false)))),
      'internal_categories_list' => new sfValidatorDoctrineChoice(array('multiple' => true, 'model' => 'InternalCategory', 'required' => false)),
      'users_list' => new sfValidatorDoctrineChoice(array('multiple' => true, 'model' => 'sfGuardUser', 'required' => false)),
    ));

    $this->widgetSchema->setNameFormat('internal_message_filters[%s]');
    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);
    $this->setupInheritance();
  }

  public function addInternalCategoriesListColumnQuery(Doctrine_Query $query, $field, $values)
  {
    if (!is_array($values))
      $values = array($values);

    if (!count($values))
      return;

    $query
      ->leftJoin($query->getRootAlias().'.InternalMessageCategory InternalMessageCategory')
      ->andWhereIn('InternalMessageCategory.internal_category_id', $values);
  }

  public function addUsersListColumnQuery(Doctrine_Query $query, $field, $values)
  {
    if (!is_array($values))
      $values = array($values);

    if (!count($values))
      return;

    $query
      ->leftJoin($query->getRootAlias().'.InternalMessageCategory InternalMessageCategory')
      ->andWhereIn('InternalMessageCategory.user_id', $values);
  }

  public function getModelName()
  {
    return 'InternalMessage';
  }

  public function getFields()
  {
    return array(
      'id'                       => 'Number',
      'internal_conversation_id' => 'ForeignKey',
      'author_id'                => 'ForeignKey',
      'receiver_id'              => 'ForeignKey',
      'is_readed'                => 'Number',
      'title'                    => 'Text',
      'description'              => 'Text',
      'created_at'               => 'Date',
      'updated_at'               => 'Date',
      'internal_categories_list' => 'ManyKey',
      'users_list'               => 'ManyKey',
    );
  }
}
