<?php

abstract class BaseMessageCenterFileFormFilter extends BaseFormFilterDoctrine
{
  public function setup()
  {
    $this->setWidgets(array(
      'message_center_id' => new sfArtWidgetFormDoctrineJQueryMultiSelect(array('multiple' => true, 'model' => $this->getRelatedModelName('MessageCenter'))),
      'file' => new sfArtWidgetFormFilterInput(array('with_empty' => false)),
      'original_filename' => new sfArtWidgetFormFilterInput(array('with_empty' => false)),
      'order' => new sfArtWidgetFormFilterInput(),
    ));

    $this->setValidators(array(
      'message_center_id' => new sfValidatorDoctrineChoice(array('required' => false, 'model' => $this->getRelatedModelName('MessageCenter'), 'column' => 'id', 'multiple'=>true)),
      'file' => new sfValidatorPass(array('required' => false)),
      'original_filename' => new sfValidatorPass(array('required' => false)),
      'order' => new sfValidatorSchemaFilter('text', new sfValidatorInteger(array('required' => false))),
    ));

    $this->widgetSchema->setNameFormat('message_center_file_filters[%s]');
    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);
    $this->setupInheritance();
  }

  public function getModelName()
  {
    return 'MessageCenterFile';
  }

  public function getFields()
  {
    return array(
      'id'                => 'Number',
      'message_center_id' => 'ForeignKey',
      'file'              => 'Text',
      'original_filename' => 'Text',
      'order'             => 'Number',
    );
  }
}
