<?php

abstract class BaseMessageCenterFormFilter extends BaseFormFilterDoctrine
{
  public function setup()
  {
    $this->setWidgets(array(
      'message_channel_id' => new sfArtWidgetFormDoctrineJQueryMultiSelect(array('multiple' => true, 'model' => $this->getRelatedModelName('MessageChannel'))),
      'layout_id' => new sfArtWidgetFormDoctrineJQueryMultiSelect(array('multiple' => true, 'model' => $this->getRelatedModelName('Layout'))),
      'collector_class' => new sfArtWidgetFormFilterInput(array('with_empty' => false)),
      'newsletter' => new sfArtWidgetFormFilterInput(),
      'unique_name' => new sfArtWidgetFormFilterInput(),
      'created_at' => new sfArtWidgetFormInputJQueryDateTimeRange(array('culture' => sfContext::getInstance()->getUser()->getCulture() )),
      'updated_at' => new sfArtWidgetFormInputJQueryDateTimeRange(array('culture' => sfContext::getInstance()->getUser()->getCulture() )),
      'users_list' => new sfArtWidgetFormDoctrineJQueryMultiselect(array('multiple' => true, 'model' => 'sfGuardUser')),
    ));

    $this->setValidators(array(
      'message_channel_id' => new sfValidatorDoctrineChoice(array('required' => false, 'model' => $this->getRelatedModelName('MessageChannel'), 'column' => 'id', 'multiple'=>true)),
      'layout_id' => new sfValidatorDoctrineChoice(array('required' => false, 'model' => $this->getRelatedModelName('Layout'), 'column' => 'id', 'multiple'=>true)),
      'collector_class' => new sfValidatorPass(array('required' => false)),
      'newsletter' => new sfValidatorSchemaFilter('text', new sfValidatorInteger(array('required' => false))),
      'unique_name' => new sfValidatorPass(array('required' => false)),
      'created_at' => new sfValidatorDateRange(array('required' => false, 'from_date' => new sfValidatorDateTime(array('required' => false)), 'to_date' => new sfValidatorDateTime(array('required' => false)))),
      'updated_at' => new sfValidatorDateRange(array('required' => false, 'from_date' => new sfValidatorDateTime(array('required' => false)), 'to_date' => new sfValidatorDateTime(array('required' => false)))),
      'users_list' => new sfValidatorDoctrineChoice(array('multiple' => true, 'model' => 'sfGuardUser', 'required' => false)),
    ));

    $this->widgetSchema->setNameFormat('message_center_filters[%s]');
    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);
    $this->setupInheritance();
  }

  public function addUsersListColumnQuery(Doctrine_Query $query, $field, $values)
  {
    if (!is_array($values))
      $values = array($values);

    if (!count($values))
      return;

    $query
      ->leftJoin($query->getRootAlias().'.UserMessageSetting UserMessageSetting')
      ->andWhereIn('UserMessageSetting.user_id', $values);
  }

  public function getModelName()
  {
    return 'MessageCenter';
  }

  public function getFields()
  {
    return array(
      'id'                 => 'Number',
      'message_channel_id' => 'ForeignKey',
      'layout_id'          => 'ForeignKey',
      'collector_class'    => 'Text',
      'newsletter'         => 'Number',
      'unique_name'        => 'Text',
      'created_at'         => 'Date',
      'updated_at'         => 'Date',
      'users_list'         => 'ManyKey',
    );
  }
}
