<?php

abstract class BaseMessageChannelFormFilter extends BaseFormFilterDoctrine
{
  public function setup()
  {
    $this->setWidgets(array(
      'channel' => new sfArtWidgetFormFilterInput(),
      'channel_class' => new sfArtWidgetFormFilterInput(),
    ));

    $this->setValidators(array(
      'channel' => new sfValidatorPass(array('required' => false)),
      'channel_class' => new sfValidatorPass(array('required' => false)),
    ));

    $this->widgetSchema->setNameFormat('message_channel_filters[%s]');
    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);
    $this->setupInheritance();
  }

  public function getModelName()
  {
    return 'MessageChannel';
  }

  public function getFields()
  {
    return array(
      'id'            => 'Number',
      'channel'       => 'Text',
      'channel_class' => 'Text',
    );
  }
}
