<?php


abstract class BaseGameTeacherPermissionFormFilter extends BaseFormFilterDoctrine
{
  public function setup()
  {
    $this->setWidgets(array(
      'sf_guard_user_permission_id' => new sfArtWidgetFormDoctrineJQueryMultiSelect(array('multiple' => true, 'model' => $this->getRelatedModelName('sfGuardUserPermission'))),
      'game_id' => new sfArtWidgetFormDoctrineJQueryMultiSelect(array('multiple' => true, 'model' => $this->getRelatedModelName('Game'))),
      'teacher_id' => new sfArtWidgetFormDoctrineJQueryMultiSelect(array('multiple' => true, 'model' => $this->getRelatedModelName('Teacher'))),
    ));

    $this->setValidators(array(
      'sf_guard_user_permission_id' => new sfValidatorDoctrineChoice(array('required' => false, 'model' => $this->getRelatedModelName('sfGuardUserPermission'), 'column' => 'id', 'multiple'=>true)),
      'game_id' => new sfValidatorDoctrineChoice(array('required' => false, 'model' => $this->getRelatedModelName('Game'), 'column' => 'id', 'multiple'=>true)),
      'teacher_id' => new sfValidatorDoctrineChoice(array('required' => false, 'model' => $this->getRelatedModelName('Teacher'), 'column' => 'id', 'multiple'=>true)),
    ));

    $this->widgetSchema->setNameFormat('game_teacher_permission_filters[%s]');
    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);
    $this->setupInheritance();
  }

  public function getModelName()
  {
    return 'GameTeacherPermission';
  }

  public function getFields()
  {
    return array(
      'id'                          => 'Number',
      'sf_guard_user_permission_id' => 'ForeignKey',
      'game_id'                     => 'ForeignKey',
      'teacher_id'                  => 'ForeignKey',
    );
  }
}
