<?php


abstract class BaseLogDecisionFormFilter extends BaseFormFilterDoctrine
{
  public function setup()
  {
    $this->setWidgets(array(
      'round_id' => new sfArtWidgetFormDoctrineJQueryMultiSelect(array('multiple' => true, 'model' => $this->getRelatedModelName('Round'))),
      'user_id' => new sfArtWidgetFormDoctrineJQueryMultiSelect(array('multiple' => true, 'model' => $this->getRelatedModelName('User'))),
      'decision' => new sfArtWidgetFormFilterInput(array('with_empty' => false)),
      'old_value' => new sfArtWidgetFormFilterInput(),
      'new_value' => new sfArtWidgetFormFilterInput(),
      'created_at' => new sfArtWidgetFormInputJQueryDateTimeRange(array('culture' => sfContext::getInstance()->getUser()->getCulture() )),
    ));

    $this->setValidators(array(
      'round_id' => new sfValidatorDoctrineChoice(array('required' => false, 'model' => $this->getRelatedModelName('Round'), 'column' => 'id', 'multiple'=>true)),
      'user_id' => new sfValidatorDoctrineChoice(array('required' => false, 'model' => $this->getRelatedModelName('User'), 'column' => 'id', 'multiple'=>true)),
      'decision' => new sfValidatorPass(array('required' => false)),
      'old_value' => new sfValidatorPass(array('required' => false)),
      'new_value' => new sfValidatorPass(array('required' => false)),
      'created_at' => new sfValidatorDateRange(array('required' => false, 'from_date' => new sfValidatorDateTime(array('required' => false)), 'to_date' => new sfValidatorDateTime(array('required' => false)))),
    ));

    $this->widgetSchema->setNameFormat('log_decision_filters[%s]');
    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);
    $this->setupInheritance();
  }

  public function getModelName()
  {
    return 'LogDecision';
  }

  public function getFields()
  {
    return array(
      'id'         => 'Number',
      'round_id'   => 'ForeignKey',
      'user_id'    => 'ForeignKey',
      'decision'   => 'Text',
      'old_value'  => 'Text',
      'new_value'  => 'Text',
      'created_at' => 'Date',
    );
  }
}
