<?php

/**
 * MenuItem filter form base class.
 *
 * @package    hotel
 * @subpackage filter
 * @author     Your name here
 * @version    SVN: $Id: sfDoctrineFormFilterGeneratedTemplate.php 29570 2010-05-21 14:49:47Z Kris.Wallsmith $
 */
abstract class BaseMenuItemFormFilter extends BaseFormFilterDoctrine
{
  public function setup()
  {
    $this->setWidgets(array(
      'menu_id' => new sfArtWidgetFormDoctrineJQueryMultiSelect(array('multiple' => true, 'model' => $this->getRelatedModelName('Menu'))),
      'submenu_id' => new sfArtWidgetFormDoctrineJQueryMultiSelect(array('multiple' => true, 'model' => $this->getRelatedModelName('Submenu'))),
      'url_type' => new sfArtWidgetFormFilterInput(array('with_empty' => false)),
      'order' => new sfArtWidgetFormFilterInput(array('with_empty' => false)),
      'json' => new sfArtWidgetFormFilterInput(),
      'created_at' => new sfArtWidgetFormInputJQueryDateTimeRange(array('culture' => sfContext::getInstance()->getUser()->getCulture() )),
      'updated_at' => new sfArtWidgetFormInputJQueryDateTimeRange(array('culture' => sfContext::getInstance()->getUser()->getCulture() )),
    ));

    $this->setValidators(array(
      'menu_id' => new sfValidatorDoctrineChoice(array('required' => false, 'model' => $this->getRelatedModelName('Menu'), 'column' => 'id', 'multiple'=>true)),
      'submenu_id' => new sfValidatorDoctrineChoice(array('required' => false, 'model' => $this->getRelatedModelName('Submenu'), 'column' => 'id', 'multiple'=>true)),
      'url_type' => new sfValidatorSchemaFilter('text', new sfValidatorInteger(array('required' => false))),
      'order' => new sfValidatorSchemaFilter('text', new sfValidatorInteger(array('required' => false))),
      'json' => new sfValidatorPass(array('required' => false)),
      'created_at' => new sfValidatorDateRange(array('required' => false, 'from_date' => new sfValidatorDateTime(array('required' => false)), 'to_date' => new sfValidatorDateTime(array('required' => false)))),
      'updated_at' => new sfValidatorDateRange(array('required' => false, 'from_date' => new sfValidatorDateTime(array('required' => false)), 'to_date' => new sfValidatorDateTime(array('required' => false)))),
    ));

    $this->widgetSchema->setNameFormat('menu_item_filters[%s]');
    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);
    $this->setupInheritance();
  }

  public function getModelName()
  {
    return 'MenuItem';
  }

  public function getFields()
  {
    return array(
      'id'         => 'Number',
      'menu_id'    => 'ForeignKey',
      'submenu_id' => 'ForeignKey',
      'url_type'   => 'Number',
      'order'      => 'Number',
      'json'       => 'Text',
      'created_at' => 'Date',
      'updated_at' => 'Date',
    );
  }
}
