<?php


abstract class BaseMessageFormFilter extends BaseFormFilterDoctrine
{
  public function setup()
  {
    $this->setWidgets(array(
      'team_id' => new sfArtWidgetFormDoctrineJQueryMultiSelect(array('multiple' => true, 'model' => $this->getRelatedModelName('Team'))),
      'user_id' => new sfArtWidgetFormDoctrineJQueryMultiSelect(array('multiple' => true, 'model' => $this->getRelatedModelName('User'))),
      'round_id' => new sfArtWidgetFormDoctrineJQueryMultiSelect(array('multiple' => true, 'model' => $this->getRelatedModelName('Round'))),
      'status' => new sfArtWidgetFormFilterInput(array('with_empty' => false)),
      'title' => new sfArtWidgetFormFilterInput(),
      'category' => new sfArtWidgetFormFilterInput(),
      'body' => new sfArtWidgetFormFilterInput(),
      'created_at' => new sfArtWidgetFormInputJQueryDateTimeRange(array('culture' => sfContext::getInstance()->getUser()->getCulture() )),
    ));

    $this->setValidators(array(
      'team_id' => new sfValidatorDoctrineChoice(array('required' => false, 'model' => $this->getRelatedModelName('Team'), 'column' => 'id', 'multiple'=>true)),
      'user_id' => new sfValidatorDoctrineChoice(array('required' => false, 'model' => $this->getRelatedModelName('User'), 'column' => 'id', 'multiple'=>true)),
      'round_id' => new sfValidatorDoctrineChoice(array('required' => false, 'model' => $this->getRelatedModelName('Round'), 'column' => 'id', 'multiple'=>true)),
      'status' => new sfValidatorSchemaFilter('text', new sfValidatorInteger(array('required' => false))),
      'title' => new sfValidatorPass(array('required' => false)),
      'category' => new sfValidatorPass(array('required' => false)),
      'body' => new sfValidatorPass(array('required' => false)),
      'created_at' => new sfValidatorDateRange(array('required' => false, 'from_date' => new sfValidatorDateTime(array('required' => false)), 'to_date' => new sfValidatorDateTime(array('required' => false)))),
    ));

    $this->widgetSchema->setNameFormat('message_filters[%s]');
    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);
    $this->setupInheritance();
  }

  public function getModelName()
  {
    return 'Message';
  }

  public function getFields()
  {
    return array(
      'id'         => 'Number',
      'team_id'    => 'ForeignKey',
      'user_id'    => 'ForeignKey',
      'round_id'   => 'ForeignKey',
      'status'     => 'Number',
      'title'      => 'Text',
      'category'   => 'Text',
      'body'       => 'Text',
      'created_at' => 'Date',
    );
  }
}
