<?php


abstract class BaseRoundFormFilter extends BaseFormFilterDoctrine
{
  public function setup()
  {
    $this->setWidgets(array(
      'team_id' => new sfArtWidgetFormDoctrineJQueryMultiSelect(array('multiple' => true, 'model' => $this->getRelatedModelName('Team'))),
      'round_number' => new sfArtWidgetFormFilterInput(array('with_empty' => false)),
      'status' => new sfArtWidgetFormFilterInput(array('with_empty' => false)),
      'name' => new sfArtWidgetFormFilterInput(),
      'round_data_json' => new sfArtWidgetFormFilterInput(),
      'round_decision_data_json' => new sfArtWidgetFormFilterInput(),
      'round_raport_data_json' => new sfArtWidgetFormFilterInput(),
      'created_at' => new sfArtWidgetFormInputJQueryDateTimeRange(array('culture' => sfContext::getInstance()->getUser()->getCulture() )),
    ));

    $this->setValidators(array(
      'team_id' => new sfValidatorDoctrineChoice(array('required' => false, 'model' => $this->getRelatedModelName('Team'), 'column' => 'id', 'multiple'=>true)),
      'round_number' => new sfValidatorSchemaFilter('text', new sfValidatorInteger(array('required' => false))),
      'status' => new sfValidatorSchemaFilter('text', new sfValidatorInteger(array('required' => false))),
      'name' => new sfValidatorPass(array('required' => false)),
      'round_data_json' => new sfValidatorPass(array('required' => false)),
      'round_decision_data_json' => new sfValidatorPass(array('required' => false)),
      'round_raport_data_json' => new sfValidatorPass(array('required' => false)),
      'created_at' => new sfValidatorDateRange(array('required' => false, 'from_date' => new sfValidatorDateTime(array('required' => false)), 'to_date' => new sfValidatorDateTime(array('required' => false)))),
    ));

    $this->widgetSchema->setNameFormat('round_filters[%s]');
    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);
    $this->setupInheritance();
  }

  public function getModelName()
  {
    return 'Round';
  }

  public function getFields()
  {
    return array(
      'id'                       => 'Number',
      'team_id'                  => 'ForeignKey',
      'round_number'             => 'Number',
      'status'                   => 'Number',
      'name'                     => 'Text',
      'round_data_json'          => 'Text',
      'round_decision_data_json' => 'Text',
      'round_raport_data_json'   => 'Text',
      'created_at'               => 'Date',
    );
  }
}
