<?php


abstract class BaseTeacherClassFormFilter extends BaseFormFilterDoctrine
{
  public function setup()
  {
    $this->setWidgets(array(
      'teacher_id' => new sfArtWidgetFormDoctrineJQueryMultiSelect(array('multiple' => true, 'model' => $this->getRelatedModelName('Teacher'))),
      'name' => new sfArtWidgetFormFilterInput(array('with_empty' => false)),
      'status' => new sfArtWidgetFormFilterInput(array('with_empty' => false)),
      'users_list' => new sfArtWidgetFormDoctrineJQueryMultiselect(array('multiple' => true, 'model' => 'sfGuardUser')),
    ));

    $this->setValidators(array(
      'teacher_id' => new sfValidatorDoctrineChoice(array('required' => false, 'model' => $this->getRelatedModelName('Teacher'), 'column' => 'id', 'multiple'=>true)),
      'name' => new sfValidatorPass(array('required' => false)),
      'status' => new sfValidatorSchemaFilter('text', new sfValidatorInteger(array('required' => false))),
      'users_list' => new sfValidatorDoctrineChoice(array('multiple' => true, 'model' => 'sfGuardUser', 'required' => false)),
    ));

    $this->widgetSchema->setNameFormat('teacher_class_filters[%s]');
    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);
    $this->setupInheritance();
  }

  public function addUsersListColumnQuery(Doctrine_Query $query, $field, $values)
  {
    if (!is_array($values))
      $values = array($values);

    if (!count($values))
      return;

    $query
      ->leftJoin($query->getRootAlias().'.ClassUser ClassUser')
      ->andWhereIn('ClassUser.user_id', $values);
  }

  public function getModelName()
  {
    return 'TeacherClass';
  }

  public function getFields()
  {
    return array(
      'id'         => 'Number',
      'teacher_id' => 'ForeignKey',
      'name'       => 'Text',
      'status'     => 'Number',
      'users_list' => 'ManyKey',
    );
  }
}
