<?php


abstract class BaseTeamFormFilter extends BaseFormFilterDoctrine
{
  public function setup()
  {
    $this->setWidgets(array(
      'game_id' => new sfArtWidgetFormDoctrineJQueryMultiSelect(array('multiple' => true, 'model' => $this->getRelatedModelName('Game'))),
      'max_users' => new sfArtWidgetFormFilterInput(array('with_empty' => false)),
      'name' => new sfArtWidgetFormFilterInput(array('with_empty' => false)),
      'logo' => new sfArtWidgetFormFilterInput(),
      'users_list' => new sfArtWidgetFormDoctrineJQueryMultiselect(array('multiple' => true, 'model' => 'sfGuardUser')),
    ));

    $this->setValidators(array(
      'game_id' => new sfValidatorDoctrineChoice(array('required' => false, 'model' => $this->getRelatedModelName('Game'), 'column' => 'id', 'multiple'=>true)),
      'max_users' => new sfValidatorSchemaFilter('text', new sfValidatorInteger(array('required' => false))),
      'name' => new sfValidatorPass(array('required' => false)),
      'logo' => new sfValidatorPass(array('required' => false)),
      'users_list' => new sfValidatorDoctrineChoice(array('multiple' => true, 'model' => 'sfGuardUser', 'required' => false)),
    ));

    $this->widgetSchema->setNameFormat('team_filters[%s]');
    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);
    $this->setupInheritance();
  }

  public function addUsersListColumnQuery(Doctrine_Query $query, $field, $values)
  {
    if (!is_array($values))
      $values = array($values);

    if (!count($values))
      return;

    $query
      ->leftJoin($query->getRootAlias().'.UserTeam UserTeam')
      ->andWhereIn('UserTeam.user_id', $values);
  }

  public function getModelName()
  {
    return 'Team';
  }

  public function getFields()
  {
    return array(
      'id'         => 'Number',
      'game_id'    => 'ForeignKey',
      'max_users'  => 'Number',
      'name'       => 'Text',
      'logo'       => 'Text',
      'users_list' => 'ManyKey',
    );
  }
}
