<?php


abstract class BaseUserDetailFormFilter extends BaseFormFilterDoctrine
{
  public function setup()
  {
    $this->setWidgets(array(
      'school' => new sfArtWidgetFormFilterInput(),
      'game_id' => new sfArtWidgetFormDoctrineJQueryMultiSelect(array('multiple' => true, 'model' => $this->getRelatedModelName('Game'))),
      'phone' => new sfArtWidgetFormFilterInput(),
      'status' => new sfArtWidgetFormFilterInput(),
      'teacher_survey_before' => new sfArtWidgetFormFilterInput(),
      'teacher_survey_after' => new sfArtWidgetFormFilterInput(),
      'student_survey_before' => new sfArtWidgetFormFilterInput(),
      'student_survey_after' => new sfArtWidgetFormFilterInput(),
      'student_test_before' => new sfArtWidgetFormFilterInput(),
      'student_test_after' => new sfArtWidgetFormFilterInput(),
      'teacher_test_grade_before' => new sfArtWidgetFormFilterInput(),
      'teacher_test_grade_after' => new sfArtWidgetFormFilterInput(),
    ));

    $this->setValidators(array(
      'school' => new sfValidatorPass(array('required' => false)),
      'game_id' => new sfValidatorDoctrineChoice(array('required' => false, 'model' => $this->getRelatedModelName('Game'), 'column' => 'id', 'multiple'=>true)),
      'phone' => new sfValidatorPass(array('required' => false)),
      'status' => new sfValidatorSchemaFilter('text', new sfValidatorInteger(array('required' => false))),
      'teacher_survey_before' => new sfValidatorPass(array('required' => false)),
      'teacher_survey_after' => new sfValidatorPass(array('required' => false)),
      'student_survey_before' => new sfValidatorPass(array('required' => false)),
      'student_survey_after' => new sfValidatorPass(array('required' => false)),
      'student_test_before' => new sfValidatorPass(array('required' => false)),
      'student_test_after' => new sfValidatorPass(array('required' => false)),
      'teacher_test_grade_before' => new sfValidatorPass(array('required' => false)),
      'teacher_test_grade_after' => new sfValidatorPass(array('required' => false)),
    ));

    $this->widgetSchema->setNameFormat('user_detail_filters[%s]');
    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);
    $this->setupInheritance();
  }

  public function getModelName()
  {
    return 'UserDetail';
  }

  public function getFields()
  {
    return array(
      'id'                        => 'Number',
      'school'                    => 'Text',
      'game_id'                   => 'ForeignKey',
      'phone'                     => 'Text',
      'status'                    => 'Number',
      'teacher_survey_before'     => 'Text',
      'teacher_survey_after'      => 'Text',
      'student_survey_before'     => 'Text',
      'student_survey_after'      => 'Text',
      'student_test_before'       => 'Text',
      'student_test_after'        => 'Text',
      'teacher_test_grade_before' => 'Text',
      'teacher_test_grade_after'  => 'Text',
    );
  }
}
