<?php


abstract class BaseUserTeamFormFilter extends BaseFormFilterDoctrine
{
  public function setup()
  {
    $this->setWidgets(array(
      'role' => new sfArtWidgetFormFilterInput(),
    ));

    $this->setValidators(array(
      'role' => new sfValidatorPass(array('required' => false)),
    ));

    $this->widgetSchema->setNameFormat('user_team_filters[%s]');
    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);
    $this->setupInheritance();
  }

  public function getModelName()
  {
    return 'UserTeam';
  }

  public function getFields()
  {
    return array(
      'user_id' => 'Number',
      'team_id' => 'Number',
      'role'    => 'Text',
    );
  }
}
