<?php


abstract class BasesfGuardGroupFormFilter extends BaseFormFilterDoctrine
{
  public function setup()
  {
    $this->setWidgets(array(
      'name' => new sfArtWidgetFormFilterInput(),
      'description' => new sfArtWidgetFormFilterInput(),
      'password_expiration_period' => new sfArtWidgetFormInputJQueryDateTimeRange(array('culture' => sfContext::getInstance()->getUser()->getCulture() )),
      'created_at' => new sfArtWidgetFormInputJQueryDateTimeRange(array('culture' => sfContext::getInstance()->getUser()->getCulture() )),
      'updated_at' => new sfArtWidgetFormInputJQueryDateTimeRange(array('culture' => sfContext::getInstance()->getUser()->getCulture() )),
      'users_list' => new sfArtWidgetFormDoctrineJQueryMultiselect(array('multiple' => true, 'model' => 'sfGuardUser')),
      'permissions_list' => new sfArtWidgetFormDoctrineJQueryMultiselect(array('multiple' => true, 'model' => 'sfGuardPermission')),
      'articles_list' => new sfArtWidgetFormDoctrineJQueryMultiselect(array('multiple' => true, 'model' => 'Article')),
    ));

    $this->setValidators(array(
      'name' => new sfValidatorPass(array('required' => false)),
      'description' => new sfValidatorPass(array('required' => false)),
      'password_expiration_period' => new sfValidatorDateRange(array('required' => false, 'from_date' => new sfValidatorDateTime(array('required' => false)), 'to_date' => new sfValidatorDateTime(array('required' => false)))),
      'created_at' => new sfValidatorDateRange(array('required' => false, 'from_date' => new sfValidatorDateTime(array('required' => false)), 'to_date' => new sfValidatorDateTime(array('required' => false)))),
      'updated_at' => new sfValidatorDateRange(array('required' => false, 'from_date' => new sfValidatorDateTime(array('required' => false)), 'to_date' => new sfValidatorDateTime(array('required' => false)))),
      'users_list' => new sfValidatorDoctrineChoice(array('multiple' => true, 'model' => 'sfGuardUser', 'required' => false)),
      'permissions_list' => new sfValidatorDoctrineChoice(array('multiple' => true, 'model' => 'sfGuardPermission', 'required' => false)),
      'articles_list' => new sfValidatorDoctrineChoice(array('multiple' => true, 'model' => 'Article', 'required' => false)),
    ));

    $this->widgetSchema->setNameFormat('sf_guard_group_filters[%s]');
    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);
    $this->setupInheritance();
  }

  public function addUsersListColumnQuery(Doctrine_Query $query, $field, $values)
  {
    if (!is_array($values))
      $values = array($values);

    if (!count($values))
      return;

    $query
      ->leftJoin($query->getRootAlias().'.sfGuardUserGroup sfGuardUserGroup')
      ->andWhereIn('sfGuardUserGroup.user_id', $values);
  }

  public function addPermissionsListColumnQuery(Doctrine_Query $query, $field, $values)
  {
    if (!is_array($values))
      $values = array($values);

    if (!count($values))
      return;

    $query
      ->leftJoin($query->getRootAlias().'.sfGuardGroupPermission sfGuardGroupPermission')
      ->andWhereIn('sfGuardGroupPermission.permission_id', $values);
  }

  public function addArticlesListColumnQuery(Doctrine_Query $query, $field, $values)
  {
    if (!is_array($values))
      $values = array($values);

    if (!count($values))
      return;

    $query
      ->leftJoin($query->getRootAlias().'.ArticleGroup ArticleGroup')
      ->andWhereIn('ArticleGroup.article_id', $values);
  }

  public function getModelName()
  {
    return 'sfGuardGroup';
  }

  public function getFields()
  {
    return array(
      'id'                         => 'Number',
      'name'                       => 'Text',
      'description'                => 'Text',
      'password_expiration_period' => 'Date',
      'created_at'                 => 'Date',
      'updated_at'                 => 'Date',
      'users_list'                 => 'ManyKey',
      'permissions_list'           => 'ManyKey',
      'articles_list'              => 'ManyKey',
    );
  }
}
