<?php


abstract class BasesfGuardUserFormFilter extends BaseFormFilterDoctrine
{
  public function setup()
  {
    $this->setWidgets(array(
      'first_name' => new sfArtWidgetFormFilterInput(),
      'last_name' => new sfArtWidgetFormFilterInput(),
      'email_address' => new sfArtWidgetFormFilterInput(array('with_empty' => false)),
      'username' => new sfArtWidgetFormFilterInput(array('with_empty' => false)),
      'algorithm' => new sfArtWidgetFormFilterInput(array('with_empty' => false)),
      'salt' => new sfArtWidgetFormFilterInput(),
      'password' => new sfArtWidgetFormFilterInput(),
      'is_active' => new sfArtWidgetFormFilterBoolRadio(),
      'is_banned' => new sfArtWidgetFormFilterBoolRadio(),
      'is_super_admin' => new sfArtWidgetFormFilterBoolRadio(),
      'last_login' => new sfArtWidgetFormInputJQueryDateTimeRange(array('culture' => sfContext::getInstance()->getUser()->getCulture() )),
      'password_expired' => new sfArtWidgetFormInputJQueryDateTimeRange(array('culture' => sfContext::getInstance()->getUser()->getCulture() )),
      'created_at' => new sfArtWidgetFormInputJQueryDateTimeRange(array('culture' => sfContext::getInstance()->getUser()->getCulture() )),
      'updated_at' => new sfArtWidgetFormInputJQueryDateTimeRange(array('culture' => sfContext::getInstance()->getUser()->getCulture() )),
      'groups_list' => new sfArtWidgetFormDoctrineJQueryMultiselect(array('multiple' => true, 'model' => 'sfGuardGroup')),
      'permissions_list' => new sfArtWidgetFormDoctrineJQueryMultiselect(array('multiple' => true, 'model' => 'sfGuardPermission')),
      'teams_list' => new sfArtWidgetFormDoctrineJQueryMultiselect(array('multiple' => true, 'model' => 'Team')),
      'message_centers_list' => new sfArtWidgetFormDoctrineJQueryMultiselect(array('multiple' => true, 'model' => 'MessageCenter')),
      'internal_messages_list' => new sfArtWidgetFormDoctrineJQueryMultiselect(array('multiple' => true, 'model' => 'InternalMessage')),
      'internal_categories_through_internal_message_category_list' => new sfArtWidgetFormDoctrineJQueryMultiselect(array('multiple' => true, 'model' => 'InternalCategory')),
      'users_list' => new sfArtWidgetFormDoctrineJQueryMultiselect(array('multiple' => true, 'model' => 'TeacherClass')),
    ));

    $this->setValidators(array(
      'first_name' => new sfValidatorPass(array('required' => false)),
      'last_name' => new sfValidatorPass(array('required' => false)),
      'email_address' => new sfValidatorPass(array('required' => false)),
      'username' => new sfValidatorPass(array('required' => false)),
      'algorithm' => new sfValidatorPass(array('required' => false)),
      'salt' => new sfValidatorPass(array('required' => false)),
      'password' => new sfValidatorPass(array('required' => false)),
      'is_active' => new sfValidatorChoice(array('required' => false, 'choices' => array('', 1, 0))),
      'is_banned' => new sfValidatorChoice(array('required' => false, 'choices' => array('', 1, 0))),
      'is_super_admin' => new sfValidatorChoice(array('required' => false, 'choices' => array('', 1, 0))),
      'last_login' => new sfValidatorDateRange(array('required' => false, 'from_date' => new sfValidatorDateTime(array('required' => false)), 'to_date' => new sfValidatorDateTime(array('required' => false)))),
      'password_expired' => new sfValidatorDateRange(array('required' => false, 'from_date' => new sfValidatorDateTime(array('required' => false)), 'to_date' => new sfValidatorDateTime(array('required' => false)))),
      'created_at' => new sfValidatorDateRange(array('required' => false, 'from_date' => new sfValidatorDateTime(array('required' => false)), 'to_date' => new sfValidatorDateTime(array('required' => false)))),
      'updated_at' => new sfValidatorDateRange(array('required' => false, 'from_date' => new sfValidatorDateTime(array('required' => false)), 'to_date' => new sfValidatorDateTime(array('required' => false)))),
      'groups_list' => new sfValidatorDoctrineChoice(array('multiple' => true, 'model' => 'sfGuardGroup', 'required' => false)),
      'permissions_list' => new sfValidatorDoctrineChoice(array('multiple' => true, 'model' => 'sfGuardPermission', 'required' => false)),
      'teams_list' => new sfValidatorDoctrineChoice(array('multiple' => true, 'model' => 'Team', 'required' => false)),
      'message_centers_list' => new sfValidatorDoctrineChoice(array('multiple' => true, 'model' => 'MessageCenter', 'required' => false)),
      'internal_messages_list' => new sfValidatorDoctrineChoice(array('multiple' => true, 'model' => 'InternalMessage', 'required' => false)),
      'internal_categories_through_internal_message_category_list' => new sfValidatorDoctrineChoice(array('multiple' => true, 'model' => 'InternalCategory', 'required' => false)),
      'users_list' => new sfValidatorDoctrineChoice(array('multiple' => true, 'model' => 'TeacherClass', 'required' => false)),
    ));

    $this->widgetSchema->setNameFormat('sf_guard_user_filters[%s]');
    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);
    $this->setupInheritance();
  }

  public function addGroupsListColumnQuery(Doctrine_Query $query, $field, $values)
  {
    if (!is_array($values))
      $values = array($values);

    if (!count($values))
      return;

    $query
      ->leftJoin($query->getRootAlias().'.sfGuardUserGroup sfGuardUserGroup')
      ->andWhereIn('sfGuardUserGroup.group_id', $values);
  }

  public function addPermissionsListColumnQuery(Doctrine_Query $query, $field, $values)
  {
    if (!is_array($values))
      $values = array($values);

    if (!count($values))
      return;

    $query
      ->leftJoin($query->getRootAlias().'.sfGuardUserPermission sfGuardUserPermission')
      ->andWhereIn('sfGuardUserPermission.permission_id', $values);
  }

  public function addTeamsListColumnQuery(Doctrine_Query $query, $field, $values)
  {
    if (!is_array($values))
      $values = array($values);

    if (!count($values))
      return;

    $query
      ->leftJoin($query->getRootAlias().'.UserTeam UserTeam')
      ->andWhereIn('UserTeam.team_id', $values);
  }

  public function addMessageCentersListColumnQuery(Doctrine_Query $query, $field, $values)
  {
    if (!is_array($values))
      $values = array($values);

    if (!count($values))
      return;

    $query
      ->leftJoin($query->getRootAlias().'.UserMessageSetting UserMessageSetting')
      ->andWhereIn('UserMessageSetting.message_center_id', $values);
  }

  public function addInternalMessagesListColumnQuery(Doctrine_Query $query, $field, $values)
  {
    if (!is_array($values))
      $values = array($values);

    if (!count($values))
      return;

    $query
      ->leftJoin($query->getRootAlias().'.InternalMessageCategory InternalMessageCategory')
      ->andWhereIn('InternalMessageCategory.internal_message_id', $values);
  }

  public function addInternalCategoriesThroughInternalMessageCategoryListColumnQuery(Doctrine_Query $query, $field, $values)
  {
    if (!is_array($values))
      $values = array($values);

    if (!count($values))
      return;

    $query
      ->leftJoin($query->getRootAlias().'.InternalMessageCategory InternalMessageCategory')
      ->andWhereIn('InternalMessageCategory.internal_category_id', $values);
  }

  public function addUsersListColumnQuery(Doctrine_Query $query, $field, $values)
  {
    if (!is_array($values))
      $values = array($values);

    if (!count($values))
      return;

    $query
      ->leftJoin($query->getRootAlias().'.ClassUser ClassUser')
      ->andWhereIn('ClassUser.class_id', $values);
  }

  public function getModelName()
  {
    return 'sfGuardUser';
  }

  public function getFields()
  {
    return array(
      'id'                                                         => 'Number',
      'first_name'                                                 => 'Text',
      'last_name'                                                  => 'Text',
      'email_address'                                              => 'Text',
      'username'                                                   => 'Text',
      'algorithm'                                                  => 'Text',
      'salt'                                                       => 'Text',
      'password'                                                   => 'Text',
      'is_active'                                                  => 'Boolean',
      'is_banned'                                                  => 'Boolean',
      'is_super_admin'                                             => 'Boolean',
      'last_login'                                                 => 'Date',
      'password_expired'                                           => 'Date',
      'created_at'                                                 => 'Date',
      'updated_at'                                                 => 'Date',
      'groups_list'                                                => 'ManyKey',
      'permissions_list'                                           => 'ManyKey',
      'teams_list'                                                 => 'ManyKey',
      'message_centers_list'                                       => 'ManyKey',
      'internal_messages_list'                                     => 'ManyKey',
      'internal_categories_through_internal_message_category_list' => 'ManyKey',
      'users_list'                                                 => 'ManyKey',
    );
  }
}
