<?php

/**
 * Base project form.
 * 
 */
class BaseForm extends artBaseForm {
  
  public function getFormFieldSchema() {
    
    if (null === $this->formFieldSchema) {
      $values = $this->isBound ? $this->taintedValues : $this->defaults + $this->widgetSchema->getDefaults();

      $this->formFieldSchema = new sfHotelFormFieldSchema($this->widgetSchema, null, null, $values, $this->errorSchema);
    }

    return $this->formFieldSchema;
  }

  public function offsetGet($name) {
    if (!isset($this->formFields[$name])) {
      if (!$widget = $this->widgetSchema[$name]) {
        throw new InvalidArgumentException(sprintf('Widget "%s" does not exist.', $name));
      }

      if ($this->isBound) {
        $value = isset($this->taintedValues[$name]) ? $this->taintedValues[$name] : null;
      } else if (isset($this->defaults[$name])) {
        $value = $this->defaults[$name];
      } else {
        $value = $widget instanceof sfWidgetFormSchema ? $widget->getDefaults() : $widget->getDefault();
      }

      $class = $widget instanceof sfWidgetFormSchema ? 'sfHotelFormFieldSchema' : 'sfHotelFormField';

      $this->formFields[$name] = new $class($widget, $this->getFormFieldSchema(), $name, $value, $this->errorSchema[$name]);
    }

    return $this->formFields[$name];
  }

}