<?php

/**
 * Klasa formularza zmiany danych JSON
 *
 *
 */
class DataJsonForm extends BaseForm {
  public function configure() {
    $this->disableCSRFProtection();
    $this->setOption('allow_extra_fields', true);
    
    $json = $this->getOption('data', null);
    if (is_null($json)) {
      throw new sfException('Brak danych do formularza. Opcja "data" jest pusta.');
    }
    
    foreach ($json as $name => $data) {
      if (is_array($data)) {
        $this->embedForm($name, new DataJsonForm(array(), array('data' => $data)));
      } else {
        $this->setWidget($name, new sfWidgetFormInputText());
        $this->setValidator($name, new sfValidatorPass());
        $this->setDefault($name, $data);
      }
    }
    
    $this->widgetSchema->setNameFormat('json_data[%s]');
    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);
  }
  
  public function save($con = null) {
    $fields = $this->getWidgetSchema()->getFields();
    $values = array();
    
    foreach ($fields as $name => $widget) {
      $values[$name] = $this->getValue($name);
    }
    
    return $values;
  }
}