<?php

/**
 * Klasa formularza zmiany danych JSON dla gry 
 * 
 * @package artCmsPlusPlugin
 *
 */
class GameDataJsonForm extends BaseForm {

    public function configure() {
        $this->disableCSRFProtection();
        $this->setOption('allow_extra_fields', true);

        $json = $this->getOption('data', null);
        $gameId = $this->getOption('game_id', null);

        if (is_null($json)) {
            if (is_null($gameId)) {
                throw new sfException('Brak opcji "game_id"');
            }
            $this->game = Doctrine::getTable('Game')->findOneById($gameId);
            $json = BaseGameData::jsonToArray($this->game->getGameDataJson());
        }

        foreach ($json as $name => $data) {
            if (is_array($data)) {
                // Pamiec nie daje rady
//        if ($name != 'macierz_wspolczynnikow' && $name != 'funkcja_popytu') {
                $this->embedForm($name, new GameDataJsonForm(array(), array('data' => $data)));
//        }
            } else {
                $this->setWidget($name, new sfWidgetFormInputText());
                $this->setValidator($name, new sfValidatorPass());
                $this->setDefault($name, $data);
            }
        }

        $this->widgetSchema->setNameFormat('game_json_data[%s]');
        $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);
    }

    public function save($con = null) {
        $json = $this->getOption('data', null);

        if (is_null($json)) {
            $fields = $this->getWidgetSchema()->getFields();
            $values = array();

            foreach ($fields as $name => $widget) {
                $values[$name] = $this->getValue($name);
            }

            $this->game->setGameDataJson(BaseGameData::arrayToJson($values));
            $this->game->save();
        } else {
            $fields = $this->getWidgetSchema()->getFields();
            $values = array();
            foreach ($fields as $name => $widget) {
                $values[$name] = $this->getValue($name);
            }
            return $values;
        }
    }

}
