<?php

/**
 * sfGuardUser form.
 *
 * @package    hotel
 * @subpackage form
 * @author     Your name here
 * @version    SVN: $Id: sfDoctrinePluginFormTemplate.php 23810 2009-11-12 11:07:44Z Kris.Wallsmith $
 */
class TeacherDetailsForm extends PluginsfGuardUserForm {

  public function configure() {
    $this->useFields(array(
        'id', 'first_name', 'last_name', 'email_address',
    ));

    $this->setWidget('school', new sfArtWidgetFormInputText());
    $this->setWidget('password', new sfArtWidgetFormInputPassword());
    $this->setValidators(array(
        'id' => new sfValidatorChoice(array('choices' => array($this->getObject()->get('id')), 'empty_value' => $this->getObject()->get('id'), 'required' => false)),
        'first_name' => new sfValidatorString(array('max_length' => 255, 'min_length' => 3, 'required' => true)),
        'last_name' => new sfValidatorString(array('max_length' => 255, 'min_length' => 2,'required' => true)),
        'email_address' => new sfValidatorEmail(array('max_length' => 255)),
        'school' => new sfValidatorString(array('max_length' => 255, 'min_length' => 2,'required' => true)),
        'password' => new sfValidatorString(array('max_length' => 128, 'required' => true)),
    ));
    $this->validatorSchema->setPostValidator(
            new sfValidatorAnd(array(
                new sfValidatorDoctrineUnique(array('model' => 'sfGuardUser', 'column' => array('email_address'))),
            ))
    );
    
    $ud = Doctrine::getTable('UserDetail')->findOneById($this->getUser()->getId()); 
    
    $this->setDefault('school', $ud->getSchool());
    
    $this->mergePostValidator(new artGuardPasswordValidator('password', $this->getObject()));
  }

  public function save($con = null) {
    $object = parent::save($con);
    
    $ud = Doctrine::getTable('UserDetail')->findOneById($this->getUser()->getId()); 
    $ud->setSchool($this->values['school']);
    $ud->save(); 
  }

}
