<?php

/**
 * Game form.
 *
 * @package    hotel
 * @author     Your name here
 */
class GameForm extends BaseGameForm
{
  
  public function configure()
  {
    unset($this['created_at'], $this['updated_at'], $this['game_data_json'], $this['game_controller_class'], $this['teacher_id'], $this['status']);
    
    $this->getWidget('name')->setAttribute('class', 'form-control');
    $this->disableRequiredsFieldText();
    $this->getWidgetSchema()->setFormFormatterName('Flaty');
  }
  
  public function bind(array $taintedValues = null, array $taintedFiles = null) {

    $gamesCount = Doctrine_Core::getTable('Game')->createQuery('g')
            ->where('g.teacher_id = ?', $this->getUser()->getId())
            ->count();

    if (($gamesCount == 0 && $this->getUser()->isTeacherDemo()) || !($this->getObject()->isNew() && $this->getUser()->isTeacherDemo())) {
      parent::bind($taintedValues, $taintedFiles);
    } else {
      $validator = new sfValidatorString(array('max_length' => 255));
      $error = new sfValidatorError($validator, _('To jest konto demo, możesz mieć tylko jedną grę.'));
      $e = new sfValidatorErrorSchema($validator, array('name' => $error));

      $this->errorSchema = $e;
    }
  }
}
