<?php

/**
 * TeacherClass form.
 *
 * @package    hotel
 * @author     Your name here
 */
class TeacherClassForm extends BaseTeacherClassForm {

  public function configure() {
    $this->useFields(array(
        'name',
    ));
  }

  public function bind(array $taintedValues = null, array $taintedFiles = null) {

    //zapytanie zliczajace ilosc klas (do ograniczenia dla konta demo)
    $classesCount = Doctrine_Core::getTable('TeacherClass')->createQuery('tc')
            ->where('tc.teacher_id = ?', $this->getUser()->getId())
            ->count();

    if (($classesCount == 0 && $this->getUser()->isTeacherDemo()) || !($this->getObject()->isNew() && $this->getUser()->isTeacherDemo())) {
      parent::bind($taintedValues, $taintedFiles);
    } else {
      $validator = new sfValidatorString(array('max_length' => 255));
      $error = new sfValidatorError($validator, _('To jest konto demo, możesz mieć tylko jedną klasę.'));
      $e = new sfValidatorErrorSchema($validator, array('name' => $error));

      $this->errorSchema = $e;
    }
  }

}
