<?php

/**
 * Team form.
 *
 * @package    hotel
 * @author     Your name here
 */
class TeamForm extends BaseTeamForm {

  public function configure() {
    $this->setWidget('users_list', new sfArtWidgetFormDoctrineJQueryMultiselect(array('multiple' => true, 'model' => 'sfGuardUser', 'table_method' => 'getUsersForTeacher')));

    $this->setValidator('users_list', new sfValidatorDoctrineChoice(array('multiple' => true, 'model' => 'sfGuardUser', 'required' => false)));

    unset($this['logo'], $this['game_id']);
    
    $this->getWidget('name')->setAttribute('class', 'form-control');
    $this->getWidget('users_list')->setAttribute('class', 'form-control');
    $this->disableRequiredsFieldText();
    $this->getWidgetSchema()->setFormFormatterName('Flaty');
  }

  public function bind(array $taintedValues = null, array $taintedFiles = null) {

    $gameId = $this->getUser()->getAttribute('game_id', false);
    
    //zapytanie zliczajace ilosc zespolow (do ograniczenia dla konta demo)
    $teamsCount = Doctrine_Core::getTable('Team')->createQuery('t')
            ->leftJoin('t.Game g')
            ->where('g.teacher_id = ?', $this->getUser()->getId())
            ->andWhere('t.game_id =?', $gameId)
            ->count();

    if (($teamsCount == 0 && $this->getUser()->isTeacherDemo()) || !($this->getObject()->isNew() && $this->getUser()->isTeacherDemo())){
      parent::bind($taintedValues, $taintedFiles);
    } else {
      $validator = new sfValidatorString();
      $error = new sfValidatorError($validator, _('To jest konto demo, możesz mieć tylko jeden zespół.'));
      $e = new sfValidatorErrorSchema($validator, array('users_list' => $error));

      $this->errorSchema = $e;
    }
  }

}
