<?php


abstract class BaseArticleCategoryForm extends BaseFormDoctrine
{
  public function setup()
  {
    $this->setWidgets(array(
      'id' => new sfWidgetFormInputHidden(),
      'category_id' => new sfArtWidgetFormDoctrineJQueryMultiSelect(array('model' => $this->getRelatedModelName('Category'), 'add_empty' => false)),
      'article_id' => new sfArtWidgetFormDoctrineJQueryMultiSelect(array('model' => $this->getRelatedModelName('Article'), 'add_empty' => true)),
      'subcategory_id' => new sfArtWidgetFormDoctrineJQueryMultiSelect(array('model' => $this->getRelatedModelName('SubCategory'), 'add_empty' => true)),
      'order' => new sfArtWidgetFormInputText(),
      'created_at' => new sfArtWidgetFormInputJQueryDateTime(),
      'updated_at' => new sfArtWidgetFormInputJQueryDateTime(),
    ));

    $this->setValidators(array(
      'id' => new sfValidatorChoice(array('choices' => array($this->getObject()->get('id')), 'empty_value' => $this->getObject()->get('id'), 'required' => false)),
      'category_id' => new sfValidatorDoctrineChoice(array('model' => $this->getRelatedModelName('Category'))),
      'article_id' => new sfValidatorDoctrineChoice(array('model' => $this->getRelatedModelName('Article'), 'required' => false)),
      'subcategory_id' => new sfValidatorDoctrineChoice(array('model' => $this->getRelatedModelName('SubCategory'), 'required' => false)),
      'order' => new sfValidatorInteger(array('required' => false)),
      'created_at' => new sfValidatorDateTime(),
      'updated_at' => new sfValidatorDateTime(),
    ));

    $this->widgetSchema->setNameFormat('article_category[%s]');
    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);
    $this->setupInheritance();
  }

  public function getModelName()
  {
    return 'ArticleCategory';
  }

}
