<?php


abstract class BaseArticleCommentForm extends BaseFormDoctrine
{
  public function setup()
  {
    $this->setWidgets(array(
      'id' => new sfWidgetFormInputHidden(),
      'article_id' => new sfArtWidgetFormDoctrineJQueryMultiSelect(array('model' => $this->getRelatedModelName('Article'), 'add_empty' => false)),
      'user_id' => new sfArtWidgetFormDoctrineJQueryMultiSelect(array('model' => $this->getRelatedModelName('sfGuardUser'), 'add_empty' => true)),
      'parent_article_comment_id' => new sfArtWidgetFormDoctrineJQueryMultiSelect(array('model' => $this->getRelatedModelName('ArticleComment'), 'add_empty' => true)),
      'text' => new sfArtWidgetFormTextarea(),
      'display' => new sfWidgetFormInputCheckbox(),
      'nick' => new sfArtWidgetFormInputText(),
      'email' => new sfArtWidgetFormInputText(),
      'www' => new sfArtWidgetFormInputText(),
      'gg' => new sfArtWidgetFormInputText(),
      'notify' => new sfWidgetFormInputCheckbox(),
      'created_at' => new sfArtWidgetFormInputJQueryDateTime(),
      'updated_at' => new sfArtWidgetFormInputJQueryDateTime(),
    ));

    $this->setValidators(array(
      'id' => new sfValidatorChoice(array('choices' => array($this->getObject()->get('id')), 'empty_value' => $this->getObject()->get('id'), 'required' => false)),
      'article_id' => new sfValidatorDoctrineChoice(array('model' => $this->getRelatedModelName('Article'))),
      'user_id' => new sfValidatorDoctrineChoice(array('model' => $this->getRelatedModelName('sfGuardUser'), 'required' => false)),
      'parent_article_comment_id' => new sfValidatorDoctrineChoice(array('model' => $this->getRelatedModelName('ArticleComment'), 'required' => false)),
      'text' => new sfValidatorString(),
      'display' => new sfValidatorBoolean(array('required' => false)),
      'nick' => new sfValidatorString(array('max_length' => 100, 'required' => false)),
      'email' => new sfValidatorString(array('max_length' => 255, 'required' => false)),
      'www' => new sfValidatorString(array('max_length' => 255, 'required' => false)),
      'gg' => new sfValidatorString(array('max_length' => 45, 'required' => false)),
      'notify' => new sfValidatorBoolean(array('required' => false)),
      'created_at' => new sfValidatorDateTime(),
      'updated_at' => new sfValidatorDateTime(),
    ));

    $this->widgetSchema->setNameFormat('article_comment[%s]');
    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);
    $this->setupInheritance();
  }

  public function getModelName()
  {
    return 'ArticleComment';
  }

}
