<?php


abstract class BaseArticleFileForm extends BaseFormDoctrine
{
  public function setup()
  {
    $this->setWidgets(array(
      'id' => new sfWidgetFormInputHidden(),
      'article_id' => new sfArtWidgetFormDoctrineJQueryMultiSelect(array('model' => $this->getRelatedModelName('Article'), 'add_empty' => false)),
      'file' => new sfWidgetFormTextarea(),
      'original_filename' => new sfWidgetFormTextarea(),
      'icon' => new sfArtWidgetFormInputText(),
      'order' => new sfArtWidgetFormInputText(),
      'created_at' => new sfArtWidgetFormInputJQueryDateTime(),
      'updated_at' => new sfArtWidgetFormInputJQueryDateTime(),
    ));

    $this->setValidators(array(
      'id' => new sfValidatorChoice(array('choices' => array($this->getObject()->get('id')), 'empty_value' => $this->getObject()->get('id'), 'required' => false)),
      'article_id' => new sfValidatorDoctrineChoice(array('model' => $this->getRelatedModelName('Article'))),
      'file' => new sfValidatorString(array('max_length' => 500)),
      'original_filename' => new sfValidatorString(array('max_length' => 500)),
      'icon' => new sfValidatorString(array('max_length' => 255, 'required' => false)),
      'order' => new sfValidatorInteger(array('required' => false)),
      'created_at' => new sfValidatorDateTime(),
      'updated_at' => new sfValidatorDateTime(),
    ));

    $this->widgetSchema->setNameFormat('article_file[%s]');
    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);
    $this->setupInheritance();
  }

  public function getModelName()
  {
    return 'ArticleFile';
  }

}
