<?php


abstract class BaseArticleForm extends BaseFormDoctrine
{
  public function setup()
  {
    $this->setWidgets(array(
      'id' => new sfWidgetFormInputHidden(),
      'creator_id' => new sfArtWidgetFormDoctrineJQueryMultiSelect(array('model' => $this->getRelatedModelName('sfGuardUser'), 'add_empty' => false)),
      'editor_id' => new sfArtWidgetFormDoctrineJQueryMultiSelect(array('model' => $this->getRelatedModelName('sfGuardUserEditor'), 'add_empty' => true)),
      'layout_id' => new sfArtWidgetFormDoctrineJQueryMultiSelect(array('model' => $this->getRelatedModelName('Layout'), 'add_empty' => false)),
      'unique_name' => new sfArtWidgetFormInputText(),
      'is_displayed' => new sfArtWidgetFormInputText(),
      'start_at' => new sfArtWidgetFormInputJQueryDateTime(),
      'expire_at' => new sfArtWidgetFormInputJQueryDateTime(),
      'flag' => new sfArtWidgetFormTextarea(),
      'title_image' => new sfArtWidgetFormInputText(),
      'title_image_label' => new sfArtWidgetFormInputText(),
      'big_image' => new sfArtWidgetFormInputText(),
      'views' => new sfArtWidgetFormInputText(),
      'vote_sum' => new sfArtWidgetFormInputText(),
      'vote_count' => new sfArtWidgetFormInputText(),
      'source' => new sfWidgetFormTextarea(),
      'created_at' => new sfArtWidgetFormInputJQueryDateTime(),
      'updated_at' => new sfArtWidgetFormInputJQueryDateTime(),
      'categories_list' => new sfArtWidgetFormDoctrineJQueryMultiselect(array('multiple' => true, 'model' => 'Category')),
      'tags_list' => new sfArtWidgetFormDoctrineJQueryMultiselect(array('multiple' => true, 'model' => 'Tag')),
      'permissions_list' => new sfArtWidgetFormDoctrineJQueryMultiselect(array('multiple' => true, 'model' => 'sfGuardPermission')),
      'groups_list' => new sfArtWidgetFormDoctrineJQueryMultiselect(array('multiple' => true, 'model' => 'sfGuardGroup')),
      'article_blog_categories_list' => new sfArtWidgetFormDoctrineJQueryMultiselect(array('multiple' => true, 'model' => 'ArticleBlogCategory')),
    ));

    $this->setValidators(array(
      'id' => new sfValidatorChoice(array('choices' => array($this->getObject()->get('id')), 'empty_value' => $this->getObject()->get('id'), 'required' => false)),
      'creator_id' => new sfValidatorDoctrineChoice(array('model' => $this->getRelatedModelName('sfGuardUser'))),
      'editor_id' => new sfValidatorDoctrineChoice(array('model' => $this->getRelatedModelName('sfGuardUserEditor'), 'required' => false)),
      'layout_id' => new sfValidatorDoctrineChoice(array('model' => $this->getRelatedModelName('Layout'))),
      'unique_name' => new sfValidatorString(array('max_length' => 100, 'required' => false)),
      'is_displayed' => new sfValidatorInteger(array('required' => false)),
      'start_at' => new sfValidatorDateTime(array('required' => false)),
      'expire_at' => new sfValidatorDateTime(array('required' => false)),
      'flag' => new sfValidatorString(array('required' => false)),
      'title_image' => new sfValidatorString(array('max_length' => 255, 'required' => false)),
      'title_image_label' => new sfValidatorString(array('max_length' => 255, 'required' => false)),
      'big_image' => new sfValidatorString(array('max_length' => 255, 'required' => false)),
      'views' => new sfValidatorInteger(array('required' => false)),
      'vote_sum' => new sfValidatorNumber(array('required' => false)),
      'vote_count' => new sfValidatorInteger(array('required' => false)),
      'source' => new sfValidatorString(array('max_length' => 500, 'required' => false)),
      'created_at' => new sfValidatorDateTime(),
      'updated_at' => new sfValidatorDateTime(),
      'categories_list' => new sfValidatorDoctrineChoice(array('multiple' => true, 'model' => 'Category', 'required' => false)),
      'tags_list' => new sfValidatorDoctrineChoice(array('multiple' => true, 'model' => 'Tag', 'required' => false)),
      'permissions_list' => new sfValidatorDoctrineChoice(array('multiple' => true, 'model' => 'sfGuardPermission', 'required' => false)),
      'groups_list' => new sfValidatorDoctrineChoice(array('multiple' => true, 'model' => 'sfGuardGroup', 'required' => false)),
      'article_blog_categories_list' => new sfValidatorDoctrineChoice(array('multiple' => true, 'model' => 'ArticleBlogCategory', 'required' => false)),
    ));

    $this->widgetSchema->setNameFormat('article[%s]');
    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);
    $this->setupInheritance();
  }

  public function getModelName()
  {
    return 'Article';
  }

  public function updateDefaultsFromObject()
  {
    parent::updateDefaultsFromObject();

    if (isset($this->widgetSchema['categories_list']))
      $this->setDefault('categories_list', $this->object->Categories->getPrimaryKeys());

    if (isset($this->widgetSchema['tags_list']))
      $this->setDefault('tags_list', $this->object->Tags->getPrimaryKeys());

    if (isset($this->widgetSchema['permissions_list']))
      $this->setDefault('permissions_list', $this->object->Permissions->getPrimaryKeys());

    if (isset($this->widgetSchema['groups_list']))
      $this->setDefault('groups_list', $this->object->Groups->getPrimaryKeys());

    if (isset($this->widgetSchema['article_blog_categories_list']))
      $this->setDefault('article_blog_categories_list', $this->object->ArticleBlogCategories->getPrimaryKeys());

  }

  protected function doSave($con = null)
  {
    $this->saveCategoriesList($con);
    $this->saveTagsList($con);
    $this->savePermissionsList($con);
    $this->saveGroupsList($con);
    $this->saveArticleBlogCategoriesList($con);

    parent::doSave($con);
  }

  public function saveCategoriesList($con = null)
  {
    if (!$this->isValid())
      throw $this->getErrorSchema();

    if (!isset($this->widgetSchema['categories_list']))
      return;

    if (null === $con)
      $con = $this->getConnection();

    $existing = $this->object->Categories->getPrimaryKeys();
    $values = $this->getValue('categories_list');
    
    if (!$this->validatorSchema['categories_list']->getOption('multiple', true))
      $values = (array)$values;
    else if (!is_array($values))
      $values = array();

    $unlink = array_diff($existing, $values);
    
    if (count($unlink))
      $this->object->unlink('Categories', array_values($unlink));

    $link = array_diff($values, $existing);
    
    if (count($link))
      $this->object->link('Categories', array_values($link));
  }

  public function saveTagsList($con = null)
  {
    if (!$this->isValid())
      throw $this->getErrorSchema();

    if (!isset($this->widgetSchema['tags_list']))
      return;

    if (null === $con)
      $con = $this->getConnection();

    $existing = $this->object->Tags->getPrimaryKeys();
    $values = $this->getValue('tags_list');
    
    if (!$this->validatorSchema['tags_list']->getOption('multiple', true))
      $values = (array)$values;
    else if (!is_array($values))
      $values = array();

    $unlink = array_diff($existing, $values);
    
    if (count($unlink))
      $this->object->unlink('Tags', array_values($unlink));

    $link = array_diff($values, $existing);
    
    if (count($link))
      $this->object->link('Tags', array_values($link));
  }

  public function savePermissionsList($con = null)
  {
    if (!$this->isValid())
      throw $this->getErrorSchema();

    if (!isset($this->widgetSchema['permissions_list']))
      return;

    if (null === $con)
      $con = $this->getConnection();

    $existing = $this->object->Permissions->getPrimaryKeys();
    $values = $this->getValue('permissions_list');
    
    if (!$this->validatorSchema['permissions_list']->getOption('multiple', true))
      $values = (array)$values;
    else if (!is_array($values))
      $values = array();

    $unlink = array_diff($existing, $values);
    
    if (count($unlink))
      $this->object->unlink('Permissions', array_values($unlink));

    $link = array_diff($values, $existing);
    
    if (count($link))
      $this->object->link('Permissions', array_values($link));
  }

  public function saveGroupsList($con = null)
  {
    if (!$this->isValid())
      throw $this->getErrorSchema();

    if (!isset($this->widgetSchema['groups_list']))
      return;

    if (null === $con)
      $con = $this->getConnection();

    $existing = $this->object->Groups->getPrimaryKeys();
    $values = $this->getValue('groups_list');
    
    if (!$this->validatorSchema['groups_list']->getOption('multiple', true))
      $values = (array)$values;
    else if (!is_array($values))
      $values = array();

    $unlink = array_diff($existing, $values);
    
    if (count($unlink))
      $this->object->unlink('Groups', array_values($unlink));

    $link = array_diff($values, $existing);
    
    if (count($link))
      $this->object->link('Groups', array_values($link));
  }

  public function saveArticleBlogCategoriesList($con = null)
  {
    if (!$this->isValid())
      throw $this->getErrorSchema();

    if (!isset($this->widgetSchema['article_blog_categories_list']))
      return;

    if (null === $con)
      $con = $this->getConnection();

    $existing = $this->object->ArticleBlogCategories->getPrimaryKeys();
    $values = $this->getValue('article_blog_categories_list');
    
    if (!$this->validatorSchema['article_blog_categories_list']->getOption('multiple', true))
      $values = (array)$values;
    else if (!is_array($values))
      $values = array();

    $unlink = array_diff($existing, $values);
    
    if (count($unlink))
      $this->object->unlink('ArticleBlogCategories', array_values($unlink));

    $link = array_diff($values, $existing);
    
    if (count($link))
      $this->object->link('ArticleBlogCategories', array_values($link));
  }

}
