<?php


abstract class BaseArticlePhotoForm extends BaseFormDoctrine
{
  public function setup()
  {
    $this->setWidgets(array(
      'id' => new sfWidgetFormInputHidden(),
      'article_id' => new sfArtWidgetFormDoctrineJQueryMultiSelect(array('model' => $this->getRelatedModelName('Article'), 'add_empty' => false)),
      'original_image' => new sfArtWidgetFormInputText(),
      'small_image' => new sfArtWidgetFormInputText(),
      'medium_image' => new sfArtWidgetFormInputText(),
      'big_image' => new sfArtWidgetFormInputText(),
      'order' => new sfArtWidgetFormInputText(),
      'created_at' => new sfArtWidgetFormInputJQueryDateTime(),
      'updated_at' => new sfArtWidgetFormInputJQueryDateTime(),
    ));

    $this->setValidators(array(
      'id' => new sfValidatorChoice(array('choices' => array($this->getObject()->get('id')), 'empty_value' => $this->getObject()->get('id'), 'required' => false)),
      'article_id' => new sfValidatorDoctrineChoice(array('model' => $this->getRelatedModelName('Article'))),
      'original_image' => new sfValidatorString(array('max_length' => 100, 'required' => false)),
      'small_image' => new sfValidatorString(array('max_length' => 100, 'required' => false)),
      'medium_image' => new sfValidatorString(array('max_length' => 100, 'required' => false)),
      'big_image' => new sfValidatorString(array('max_length' => 100, 'required' => false)),
      'order' => new sfValidatorInteger(array('required' => false)),
      'created_at' => new sfValidatorDateTime(),
      'updated_at' => new sfValidatorDateTime(),
    ));

    $this->widgetSchema->setNameFormat('article_photo[%s]');
    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);
    $this->setupInheritance();
  }

  public function getModelName()
  {
    return 'ArticlePhoto';
  }

}
