<?php


abstract class BaseArticleTranslationForm extends BaseFormDoctrine
{
  public function setup()
  {
    $this->setWidgets(array(
      'id' => new sfWidgetFormInputHidden(),
      'title' => new sfArtWidgetFormInputText(),
      'description' => new sfArtWidgetFormTextarea(),
      'short_description' => new sfWidgetFormTextarea(),
      'meta_title' => new sfArtWidgetFormInputText(),
      'meta_description' => new sfWidgetFormTextarea(),
      'meta_keywords' => new sfWidgetFormTextarea(),
      'lang' => new sfWidgetFormInputHidden(),
      'slug' => new sfArtWidgetFormInputText(),
    ));

    $this->setValidators(array(
      'id' => new sfValidatorChoice(array('choices' => array($this->getObject()->get('id')), 'empty_value' => $this->getObject()->get('id'), 'required' => false)),
      'title' => new sfValidatorString(array('max_length' => 255)),
      'description' => new sfValidatorString(),
      'short_description' => new sfValidatorString(array('max_length' => 1000, 'required' => false)),
      'meta_title' => new sfValidatorString(array('max_length' => 255, 'required' => false)),
      'meta_description' => new sfValidatorString(array('max_length' => 1000, 'required' => false)),
      'meta_keywords' => new sfValidatorString(array('max_length' => 1000, 'required' => false)),
      'lang' => new sfValidatorChoice(array('choices' => array($this->getObject()->get('lang')), 'empty_value' => $this->getObject()->get('lang'), 'required' => false)),
      'slug' => new sfValidatorString(array('max_length' => 255, 'required' => false)),
    ));

    $this->validatorSchema->setPostValidator(
      new sfValidatorDoctrineUnique(array('model' => 'ArticleTranslation', 'column' => array('slug', 'lang', 'title')))
    );

    $this->widgetSchema->setNameFormat('article_translation[%s]');
    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);
    $this->setupInheritance();
  }

  public function getModelName()
  {
    return 'ArticleTranslation';
  }

}
