<?php


abstract class BaseCategoryForm extends BaseFormDoctrine
{
  public function setup()
  {
    $this->setWidgets(array(
      'id' => new sfWidgetFormInputHidden(),
      'title_image' => new sfArtWidgetFormInputText(),
      'unique_name' => new sfArtWidgetFormInputText(),
      'image_count' => new sfArtWidgetFormInputText(),
      'layout_id' => new sfArtWidgetFormDoctrineJQueryMultiSelect(array('model' => $this->getRelatedModelName('Layout'), 'add_empty' => false)),
      'is_displayed' => new sfArtWidgetFormInputText(),
      'subcategories_list' => new sfArtWidgetFormDoctrineJQueryMultiselect(array('multiple' => true, 'model' => 'Category')),
      'articles_list' => new sfArtWidgetFormDoctrineJQueryMultiselect(array('multiple' => true, 'model' => 'Article')),
      'category_list' => new sfArtWidgetFormDoctrineJQueryMultiselect(array('multiple' => true, 'model' => 'Category')),
    ));

    $this->setValidators(array(
      'id' => new sfValidatorChoice(array('choices' => array($this->getObject()->get('id')), 'empty_value' => $this->getObject()->get('id'), 'required' => false)),
      'title_image' => new sfValidatorString(array('max_length' => 255, 'required' => false)),
      'unique_name' => new sfValidatorString(array('max_length' => 100, 'required' => false)),
      'image_count' => new sfValidatorInteger(array('required' => false)),
      'layout_id' => new sfValidatorDoctrineChoice(array('model' => $this->getRelatedModelName('Layout'))),
      'is_displayed' => new sfValidatorInteger(array('required' => false)),
      'subcategories_list' => new sfValidatorDoctrineChoice(array('multiple' => true, 'model' => 'Category', 'required' => false)),
      'articles_list' => new sfValidatorDoctrineChoice(array('multiple' => true, 'model' => 'Article', 'required' => false)),
      'category_list' => new sfValidatorDoctrineChoice(array('multiple' => true, 'model' => 'Category', 'required' => false)),
    ));

    $this->widgetSchema->setNameFormat('category[%s]');
    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);
    $this->setupInheritance();
  }

  public function getModelName()
  {
    return 'Category';
  }

  public function updateDefaultsFromObject()
  {
    parent::updateDefaultsFromObject();

    if (isset($this->widgetSchema['subcategories_list']))
      $this->setDefault('subcategories_list', $this->object->Subcategories->getPrimaryKeys());

    if (isset($this->widgetSchema['articles_list']))
      $this->setDefault('articles_list', $this->object->Articles->getPrimaryKeys());

    if (isset($this->widgetSchema['category_list']))
      $this->setDefault('category_list', $this->object->Category->getPrimaryKeys());

  }

  protected function doSave($con = null)
  {
    $this->saveSubcategoriesList($con);
    $this->saveArticlesList($con);
    $this->saveCategoryList($con);

    parent::doSave($con);
  }

  public function saveSubcategoriesList($con = null)
  {
    if (!$this->isValid())
      throw $this->getErrorSchema();

    if (!isset($this->widgetSchema['subcategories_list']))
      return;

    if (null === $con)
      $con = $this->getConnection();

    $existing = $this->object->Subcategories->getPrimaryKeys();
    $values = $this->getValue('subcategories_list');
    
    if (!$this->validatorSchema['subcategories_list']->getOption('multiple', true))
      $values = (array)$values;
    else if (!is_array($values))
      $values = array();

    $unlink = array_diff($existing, $values);
    
    if (count($unlink))
      $this->object->unlink('Subcategories', array_values($unlink));

    $link = array_diff($values, $existing);
    
    if (count($link))
      $this->object->link('Subcategories', array_values($link));
  }

  public function saveArticlesList($con = null)
  {
    if (!$this->isValid())
      throw $this->getErrorSchema();

    if (!isset($this->widgetSchema['articles_list']))
      return;

    if (null === $con)
      $con = $this->getConnection();

    $existing = $this->object->Articles->getPrimaryKeys();
    $values = $this->getValue('articles_list');
    
    if (!$this->validatorSchema['articles_list']->getOption('multiple', true))
      $values = (array)$values;
    else if (!is_array($values))
      $values = array();

    $unlink = array_diff($existing, $values);
    
    if (count($unlink))
      $this->object->unlink('Articles', array_values($unlink));

    $link = array_diff($values, $existing);
    
    if (count($link))
      $this->object->link('Articles', array_values($link));
  }

  public function saveCategoryList($con = null)
  {
    if (!$this->isValid())
      throw $this->getErrorSchema();

    if (!isset($this->widgetSchema['category_list']))
      return;

    if (null === $con)
      $con = $this->getConnection();

    $existing = $this->object->Category->getPrimaryKeys();
    $values = $this->getValue('category_list');
    
    if (!$this->validatorSchema['category_list']->getOption('multiple', true))
      $values = (array)$values;
    else if (!is_array($values))
      $values = array();

    $unlink = array_diff($existing, $values);
    
    if (count($unlink))
      $this->object->unlink('Category', array_values($unlink));

    $link = array_diff($values, $existing);
    
    if (count($link))
      $this->object->link('Category', array_values($link));
  }

}
